<?php
declare(strict_types=1);

/**
 * VisionMedia Bot — config/env.php (FINAL, CLEAN)
 * نکات:
 *  - UTF-8 بدون BOM
 *  - هیچ کاراکتری قبل از <?php نباشد
 *  - این فایل جایگزین کامل نسخه‌ی قبلی شود
 */

/* ────────── محیط و زمان ────────── */
define('VM_ENV', 'prod'); // prod | dev
date_default_timezone_set('Asia/Tehran');

// اگر از تاریخ شمسی استفاده می‌کنی، این رو on بگذار (ما در utils.php jdate داریم)
if (!defined('VM_JALALI')) {
    define('VM_JALALI', true);
}

/* ────────── Bot Token و نقش‌ها ──────────
 * core/telegram.php در پیِ BOT_TOKEN یا TELEGRAM_BOT_TOKEN می‌گردد.
 * پس حتماً یکی از این‌ها را ست کن. من هر دو را همسو کردم.
 */
define('BOT_TOKEN', '7366324571:AAEBRqKRKnaCKhnSqmxfqMwclfOqtvjB_QI');
define('TELEGRAM_BOT_TOKEN', BOT_TOKEN); // همسان‌سازی برای سازگاری عقب‌رو
define('CEO_UID', 894457439);           // آی‌دی عددی مدیرعامل

/* ────────── Webhook Base (اختیاری) ──────────
 * فقط برای نمایش لینک‌ها/خروجی‌ها مفید است. وبهوک را با core/telegram.php → tg_set_webhook ست کن.
 */
define('WEBHOOK_BASE', 'https://vernaoil.com/vision_media_bot/bot/');

/* ────────── مشخصات شرکت (برای قرارداد/صورتجلسه/فاکتور) ────────── */
define('COMPANY_LEGAL_NAME', 'البرز مدیا دوراندیش (ویژن مدیا)');
define('COMPANY_REG_NO',     '۴۲۵۶۳');
define('COMPANY_NATIONAL_ID','۱۴۰۱۱۱۲۸۲۲۲');
define('COMPANY_ADDRESS',    'کرج ، جهانشهر، میدان سپاه ، مجتمع تجاری گلستان');
define('COMPANY_PHONES',     '۰۹۳۳۱۹۰۳۸۷۷ / ۰۹۹۸۱۳۸۱۷۳ / ۰۲۶۳۴۴۲۵۸۸ / ۰۲۱۹۱۳۰۵۸۸۳');
define('COMPANY_WEBSITE',    'www.visionmedia.ir');

/* ادامه: config/env.php */

/* ────────── اطلاعات پرداخت ────────── */
define('PAY_CARD', '5859838820334401');
define('PAY_ACC',  '03590300021');
define('PAY_IBAN', 'IR410180000000103590300021');
define('PAY_NAME', 'شرکت البرز مدیا دور اندیش (ویژن مدیا)');

/* ────────── مسیرهای ذخیره‌سازی ────────── */
define('VM_STORAGE', __DIR__ . '/../storage');
define('VM_LOGS',    __DIR__ . '/../storage/logs');

// ایجاد پوشه‌ها در صورت نبود (بدون خطا در هاست اشتراکی)
@is_dir(VM_STORAGE) || @mkdir(VM_STORAGE, 0775, true);
@is_dir(VM_LOGS)    || @mkdir(VM_LOGS,    0775, true);
@is_dir(__DIR__ . '/../storage/exports') || @mkdir(__DIR__ . '/../storage/exports', 0775, true);

/* ────────── ددلاین‌ها و قوانین ────────── */
define('OFFISH_QUOTA',                    3);  // سهمیه ماهانه آفیش
define('OFFISH_FIRST_DEADLINE_DAYS',      7);  // تا اولین آفیش
define('OFFISH_FINISH_BTN_DELAY',         30); // دقیقه بعد از حضور
define('SCENARIO_DEADLINE_HOURS',         30);
define('EDITOR_CHECK_DEADLINE_HOURS',     24);
define('EDITOR_FIRST_VIDEO_DEADLINE_HOURS',24);
define('VIDEOGRAPHER_DEADLINE_HOURS',     24);

/* ────────── قالب ابلاغ جریمه ────────── */
define('PENALTY_TEMPLATE', 
"#جریمه
🔴 تاریخ: {date}
🔴 نام پرسنل: {name}
🔴 دلیل جریمه: {reason}
🔴 مبلغ جریمه: {amount}

بنابر دستور مدیریت و حسابداری کاملاً لازم‌الاجراست."
);

/* ────────── دیتابیس (فعلاً غیرفعال) ────────── */
define('DB_ENABLED', false);
define('DB_DSN',  'mysql:host=localhost;dbname=visionmedia;charset=utf8mb4');
define('DB_USER', 'user');
define('DB_PASS', 'pass');

/* ────────── چک سلامت ساده ────────── */
if (!defined('BOT_TOKEN') || BOT_TOKEN === '') {
    // لاگ نرم؛ اسکریپت کرش نکند
    if (!function_exists('app_log')) {
        function app_log(string $msg): void {
            $f = __DIR__ . '/../storage/logs/app.log';
            @file_put_contents($f, '['.date('Y-m-d H:i:s')."] ".$msg."\n", FILE_APPEND);
        }
    }
    app_log('BOT_TOKEN is empty! Please set in config/env.php');
}
