<?php
declare(strict_types=1);

/**
 * VisionMedia Bot — core/utils.php
 * ابزارهای عمومی:
 * - escape و formatting
 * - تاریخ شمسی (JDate)
 * - تبدیل عدد به فارسی
 * - money format
 * - ساخت کیبورد تلگرام
 */

if (!function_exists('tg_escape')) {
    function tg_escape(string $t): string {
        return htmlspecialchars($t, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8');
    }
}

/* ────────── تاریخ شمسی (JDate) ────────── */
// نیازمند ext-calendar یا کتابخانه jDate ساده
if (!function_exists('jdate')) {
    function jdate(string $format, int $ts=null): string {
        $ts = $ts ?? time();
        // الگوریتم تبدیل میلادی → شمسی (ساده)
        $gY = (int)date('Y',$ts);
        $gM = (int)date('m',$ts);
        $gD = (int)date('d',$ts);

        // تبدیل ساده: الگوریتم رسمی جلالی
        $gy = $gY-1600; $gm=$gM-1; $gd=$gD-1;
        $g_day_no = 365*$gy + (int)(($gy+3)/4) - (int)(($gy+99)/100) + (int)(($gy+399)/400);
        for ($i=0;$i<$gm;$i++) $g_day_no += [31,28,31,30,31,30,31,31,30,31,30,31][$i];
        if ($gm>1 && (($gy%4==0 && $gy%100!=0) || ($gy%400==0))) $g_day_no++;
        $g_day_no += $gd;
        $j_day_no = $g_day_no-79;
        $j_np = (int)($j_day_no/12053); $j_day_no %= 12053;
        $jy = 979+33*$j_np+4*(int)($j_day_no/1461);
        $j_day_no %=1461;
        if ($j_day_no>=366) {
            $jy+=(int)(($j_day_no-1)/365);
            $j_day_no=($j_day_no-1)%365;
        }
        for($i=0; $i<11 && $j_day_no>=[31,31,31,31,31,31,30,30,30,30,30,29][$i]; $i++)
            $j_day_no -= [31,31,31,31,31,31,30,30,30,30,30,29][$i];
        $jm=$i+1; $jd=$j_day_no+1;

        $out = $format;
        $out = str_replace(['Y','m','d'], [sprintf('%04d',$jy), sprintf('%02d',$jm), sprintf('%02d',$jd)], $out);
        $out = str_replace(['H','i','s'], [date('H',$ts), date('i',$ts), date('s',$ts)], $out);
        return $out;
    }
}

/* ────────── تبدیل اعداد به فارسی ────────── */
if (!function_exists('to_persian_num')) {
    function to_persian_num($input): string {
        $num = strval($input);
        $en = ['0','1','2','3','4','5','6','7','8','9'];
        $fa = ['۰','۱','۲','۳','۴','۵','۶','۷','۸','۹'];
        return str_replace($en,$fa,$num);
    }
}

/* ────────── Money Format ────────── */
if (!function_exists('money')) {
    function money(int $rials): string {
        return to_persian_num(number_format($rials))." تومان";
    }
}

/* ادامه core/utils.php */

// ────────── کیبوردهای تلگرام ──────────
if (!function_exists('kb_btn')) {
    function kb_btn(string $text, string $data): array {
        return ['text'=>$text, 'callback_data'=>$data];
    }
}
if (!function_exists('kb_inline')) {
    function kb_inline(array $rows): array {
        return ['inline_keyboard'=>$rows];
    }
}
if (!function_exists('tg_send_html')) {
    function tg_send_html(int $chat_id, string $text): void {
        tg_request('sendMessage',[
            'chat_id'=>$chat_id,
            'text'=>$text,
            'parse_mode'=>'HTML'
        ]);
    }
}
if (!function_exists('tg_send_kb_html')) {
    function tg_send_kb_html(int $chat_id, string $text, array $kb): void {
        tg_request('sendMessage',[
            'chat_id'=>$chat_id,
            'text'=>$text,
            'parse_mode'=>'HTML',
            'reply_markup'=>json_encode($kb,JSON_UNESCAPED_UNICODE)
        ]);
    }
}
if (!function_exists('tg_answer_cb')) {
    function tg_answer_cb(string $text='', bool $alert=false): void {
        global $update;
        if (!isset($update['callback_query']['id'])) return;
        tg_request('answerCallbackQuery',[
            'callback_query_id'=>$update['callback_query']['id'],
            'text'=>$text,
            'show_alert'=>$alert
        ]);
    }
}
