<?php
declare(strict_types=1);

require_once __DIR__ . '/../core/utils.php';
require_once __DIR__ . '/../core/storage.php';
require_once __DIR__ . '/../core/telegram.php';
require_once __DIR__ . '/../modules/accounting.php';
require_once __DIR__ . '/../config/env.php';

if (!defined('INVC_FILE')) define('INVC_FILE', VM_STORAGE . '/invoices.json');

function cust_menu_main(int $chat_id): void {
    $kb = kb_inline([
        [ kb_btn('🛍️ فروشگاه خدمات', 'cust:shop'), kb_btn('🧾 فاکتور/سبد من', 'shop:cart:view') ],
        [ kb_btn('📦 سرویس‌های من', 'cust:services') ],
    ]);
    $msg = "🤝 خوش اومدی به پنل مشتری ویژن‌مدیا!\nاز اینجا می‌تونی سرویس بخری، فاکتورت رو ببینی و تمدید انجام بدی ✨";
    tg_send_kb_html($chat_id, $msg, $kb);
}

function cust_services_view(int $chat_id): void {
    $invoices = storage_load(INVC_FILE, []);
    $paid = array_values(array_filter($invoices, fn($inv)=> (int)($inv['customer_chat_id']??0)===$chat_id && ($inv['status']??'')==='paid'));
    if (!$paid) { tg_send_html($chat_id,'هنوز سرویس فعالی ثبت نشده است.'); return; }
    usort($paid, fn($a,$b)=>($b['created_ts']??0)<=>($a['created_ts']??0)); $paid=array_slice($paid,0,5);
    $out="📦 <b>سرویس‌های من</b>\n";
    foreach($paid as $inv){ $id=(int)$inv['id']; $lines=[]; foreach(($inv['items']??[]) as $it){ $lines[]="• ".tg_escape($it['title'])." — ".money((int)$it['price']); } $out.="— فاکتور #".to_persian_num($id)." (پرداخت‌شده)\n".implode("\n",$lines)."\n\n"; }
    tg_send_html($chat_id,$out);
}

function cust_shop(int $chat_id): void { shop_render_for_customer($chat_id); }

function cust_cart_view(int $chat_id): void {
    $invoices=inv_list(); $open=null; foreach($invoices as $inv){ if((int)$inv['customer_chat_id']===$chat_id && in_array(($inv['status']??'unpaid'),['unpaid','partial'],true)){ $open=$inv; break; } }
    if(!$open){ tg_send_html($chat_id,'سبد فعالی ندارید.'); return; }
    tg_send_html($chat_id, inv_render_view_for_customer((int)$open['id']));
}

function customer_handle_callback(int $chat_id, int $user_id, string $data): bool {
    if (acc_handle_customer_callback($chat_id, $data)) return true;
    if ($data==='cust:services'){ cust_services_view($chat_id); return true; }
    if ($data==='cust:menu'){ cust_menu_main($chat_id); return true; }
    return false;
}

function customer_handle_text(int $chat_id, string $text): bool {
    $t=trim($text);
    if ($t==='/start') { cust_menu_main($chat_id); return true; }
    if ($t==='فروشگاه' || $t==='shop'){ cust_shop($chat_id); return true; }
    if ($t==='سبد' || $t==='فاکتور'){ cust_cart_view($chat_id); return true; }
    if ($t==='سرویس‌های من'){ cust_services_view($chat_id); return true; }
    return false;
}

return true;
