<?php
declare(strict_types=1);

/** Vision Media Bot — cron.php (standalone runner) */

error_reporting(E_ALL);
ini_set('display_errors', '0');

chdir(dirname(__DIR__)); // → /bot
require_once __DIR__ . '/../config.php';
if (!is_dir(LOG_DIR)) @mkdir(LOG_DIR, 0775, true);
ini_set('log_errors', '1');
ini_set('error_log', LOG_DIR . '/php-error.log');

require_once __DIR__ . '/../functions/utils.php';
require_once __DIR__ . '/../functions/telegram.php';
require_once __DIR__ . '/../functions/conversation.php';
require_once __DIR__ . '/../functions/storage.php';
require_once __DIR__ . '/../functions/users.php';
require_once __DIR__ . '/../functions/approvals.php';
require_once __DIR__ . '/../functions/penalties.php';
require_once __DIR__ . '/../functions/tasks.php';
require_once __DIR__ . '/../functions/calendar.php';
require_once __DIR__ . '/../functions/accounting.php';

/** حذف پیام‌های یادآور قدیمی (هر 20 دقیقه تمیزکاری) */
function cron_cleanup_messages(): void {
    $sched_file = STORAGE['schedules'];
    $all = storage_load($sched_file);
    if (!$all) return;

    $now = time();
    $keep = [];
    foreach ($all as $s) {
        if (($s['type'] ?? '') === 'delete_msg' && ($s['time'] ?? 0) <= $now) {
            $chat = (int)($s['chat'] ?? 0);
            $mid  = (int)($s['msg_id'] ?? 0);
            if ($chat && $mid) { @tg_delete_msg($chat, $mid); }
            continue;
        }
        $keep[] = $s;
    }
    storage_save($sched_file, $keep);
}

$start = microtime(true);

// یادآوری‌ها و جریمه دیرکرد فاکتور
acc_reminders_run();

// یادآور وظایف + جریمه دیرکرد وظایف
task_send_reminders();
task_check_overdue();
task_cleanup();

// تمیزکاری پیام‌ها
cron_cleanup_messages();

// خروجی لاگ کوتاه
file_put_contents(LOG_DIR.'/cron-'.date('Y-m-d').'.log',
    "[".date('H:i:s')."] OK (".round((microtime(true)-$start)*1000)."ms)\n",
    FILE_APPEND
);

echo "CRON-OK\n";
