CREATE TABLE IF NOT EXISTS users (
  id INT AUTO_INCREMENT PRIMARY KEY,
  tg_id BIGINT UNIQUE,
  name VARCHAR(100),
  phone VARCHAR(32),
  role VARCHAR(50),
  status ENUM('pending','approved','customer') DEFAULT 'pending',
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS roles (
  id INT AUTO_INCREMENT PRIMARY KEY,
  name VARCHAR(50),
  fa_name VARCHAR(100)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

INSERT INTO roles (name, fa_name) VALUES
('CEO','👑 مدیرعامل'),('Accountant','💰 حسابدار'),('DepartmentManager','🧩 مدیر دپارتمان'),
('SeniorAdmin','⚙️ ادمین ارشد'),('Admin','🛠 ادمین'),('Customer','🧍 مشتری'),
('Blogger','📝 بلاگر'),('Editor','🎞 تدوینگر'),('ScriptWriter','📜 سناریونویس'),('Photographer','📷 تصویربردار');
