<?php
// Hotfix v89 — Guard for tg_send_html / tg_answer_callback
// This file avoids 'Cannot redeclare tg_send_html()' by defining functions only if missing.

if (!function_exists('tg_get_token')) {
  function tg_get_token(){
    $cfg_file = __DIR__ . '/../storage/config.json';
    $cfg = is_file($cfg_file) ? @json_decode(@file_get_contents($cfg_file), true) : [];
    foreach (['bot_token','token','TOKEN','BOT_TOKEN','telegram_token'] as $k) {
      if (!empty($cfg[$k])) return $cfg[$k];
    }
    return '';
  }
}

if (!function_exists('tg_send_html')) {
  function tg_send_html($chat_id, $text, $kb=null){
    $t = tg_get_token();
    if (!$t) return;
    // Normalize reply_markup to avoid 'inline_keyboard must be of type Array'
    $markup = null;
    if (is_string($kb) && $kb!=='') { $dec=@json_decode($kb,true); if (is_array($dec)) $markup=$dec; }
    elseif (is_array($kb)) { $markup=$kb; }
    if (is_array($markup)){
      if (isset($markup['inline_keyboard']) && !is_array($markup['inline_keyboard'])) {
        $markup['inline_keyboard'] = [ (array)$markup['inline_keyboard'] ];
      }
      if (!isset($markup['inline_keyboard']) && !isset($markup['keyboard'])) {
        $markup = ['inline_keyboard'=>$markup];
      }
    }
    $url='https://api.telegram.org/bot'.$t.'/sendMessage';
    $p=['chat_id'=>(int)$chat_id,'text'=>$text,'parse_mode'=>'HTML'];
    if (is_array($markup)) $p['reply_markup']=json_encode($markup, JSON_UNESCAPED_UNICODE);
    $ctx=stream_context_create(['http'=>['method'=>'POST','header'=>'Content-Type: application/json','content'=>json_encode($p,JSON_UNESCAPED_UNICODE)]]);
    @file_get_contents($url,false,$ctx);
  }
}

if (!function_exists('tg_answer_callback')) {
  function tg_answer_callback($callback_query_id, $text='', $show_alert=false){
    $t = tg_get_token();
    if (!$t) return;
    $url='https://api.telegram.org/bot'.$t.'/answerCallbackQuery';
    $p=['callback_query_id'=>$callback_query_id];
    if ($text!=='') $p['text']=$text;
    if ($show_alert) $p['show_alert']=true;
    $ctx=stream_context_create(['http'=>['method'=>'POST','header'=>'Content-Type: application/json','content'=>json_encode($p,JSON_UNESCAPED_UNICODE)]]);
    @file_get_contents($url,false,$ctx);
  }
}
