<?php
// ceo_plus.php (v89-acc) — adds Accounting button without removing any
if (!function_exists('tg_send_html')) {
  function tg_send_html($chat_id,$text,$kb=null){
    $cfg=__DIR__.'/../storage/config.json'; $d=@json_decode(@file_get_contents($cfg),true); $t='';
    foreach(['bot_token','token','TOKEN','BOT_TOKEN','telegram_token'] as $k){ if(!empty($d[$k])){$t=$d[$k]; break;} }
    if(!$t) return; $url='https://api.telegram.org/bot'.$t.'/sendMessage';
    $p=['chat_id'=>(int)$chat_id,'text'=>$text,'parse_mode'=>'HTML'];
    if(is_array($kb)) $p['reply_markup']=json_encode($kb,JSON_UNESCAPED_UNICODE);
    $ctx=stream_context_create(['http'=>['method'=>'POST','header'=>'Content-Type: application/json','content'=>json_encode($p,JSON_UNESCAPED_UNICODE)]]);
    @file_get_contents($url,false,$ctx);
  }
}

if (!function_exists('ceo_plus_menu')) {
  function ceo_plus_menu($chat_id,$from=[]){
    $rows=[
      [ ['text'=>'⚙️ تنظیمات','callback_data'=>'ceo:settings'], ['text'=>'📊 داشبورد','callback_data'=>'ceo:dash'] ],
      [ ['text'=>'🛠 امکانات','callback_data'=>'ceo:features'], ['text'=>'🛒 فروشگاه','callback_data'=>'ceo:store'] ],
      [ ['text'=>'💰 مالی','callback_data'=>'ceo:finance'], ['text'=>'🚨 جریمه‌ها','callback_data'=>'ceo:penalties'] ],
      [ ['text'=>'🗒️ وظایف','callback_data'=>'ceo:tasks'], ['text'=>'🎬 آفیش‌ها','callback_data'=>'ceo:offish'] ],
      [ ['text'=>'👨‍💼 پرسنل','callback_data'=>'ceo:dir:employees'], ['text'=>'👥 مشتریان','callback_data'=>'ceo:dir:customers'] ],
      [ ['text'=>'👷‍♂️ مدیر دپارتمان','callback_data'=>'ceo:open_dm'], ['text'=>'📑 حسابداری','callback_data'=>'ceo:open_acc'] ]
    ];
    tg_send_html($chat_id,"<b>پنل مدیرعامل</b>\nیکی را انتخاب کنید:",['inline_keyboard'=>$rows]);
  }

  function ceo_plus_handle($data,$chat_id,$from=[]){
    $d=str_replace(['|','/'],':',$data);
    if ($d==='ceo:menu'){ ceo_plus_menu($chat_id,$from); return; }

    if ($d==='ceo:open_dm'){
      if (function_exists('dm_menu')) dm_menu($chat_id);
      elseif (function_exists('dm2_menu')) dm2_menu($chat_id);
      else tg_send_html($chat_id,'پنل مدیر دپارتمان نصب نیست.');
      return;
    }

    if ($d==='ceo:open_acc'){
      @require_once __DIR__.'/ceo_acc_bridge.php';
      if (function_exists('ceo_open_acc_menu')) ceo_open_acc_menu($chat_id);
      else tg_send_html($chat_id,'پنل حسابداری نصب نیست.');
      return;
    }

    // Directory routes (if present)
    if (strpos($d,'ceo:dir:')===0){
      @require_once __DIR__.'/ceo_directory.php';
      if (function_exists('ceo_dir_route')) { ceo_dir_route($d,$chat_id,$from); return; }
    }

    $labels=[ 'ceo:settings'=>'تنظیمات', 'ceo:dash'=>'داشبورد', 'ceo:features'=>'امکانات', 'ceo:finance'=>'بخش مالی', 'ceo:store'=>'فروشگاه', 'ceo:penalties'=>'جریمه‌ها', 'ceo:tasks'=>'وظایف', 'ceo:offish'=>'آفیش‌ها' ];
    if(isset($labels[$d])){ tg_send_html($chat_id,"<b>".$labels[$d]."</b> (در حال تکمیل)"); return; }

    tg_send_html($chat_id,'دستور ناشناخته در پنل مدیرعامل.');
  }
}
