<?php
/**
 * VisionMedia index.php  (v89.2 full)
 * - Anti-500 (always 200 OK to Telegram; logs errors)
 * - GET health (no 404)
 * - Unified sender (normalizes reply_markup to avoid inline_keyboard errors)
 * - Safe lazy-load handlers
 * - CEO autopanel: /start auto-opens CEO panel if user is in owners.json; /ceo shows full menu
 */

@ini_set('display_errors','0');
@ini_set('log_errors','1');
date_default_timezone_set('Asia/Tehran');

$BASE = __DIR__;
$STO  = $BASE . '/storage';
$LOGD = $STO . '/logs';
if (!is_dir($STO)) @mkdir($STO,0777,true);
if (!is_dir($LOGD)) @mkdir($LOGD,0777,true);

function vmlog($m){ @file_put_contents(__DIR__.'/storage/logs/webhook.log','['.date('Y-m-d H:i:s').'] '.$m."\n",FILE_APPEND); }

register_shutdown_function(function(){
  $e=error_get_last();
  if($e && in_array($e['type'],[E_ERROR,E_PARSE,E_CORE_ERROR,E_COMPILE_ERROR])){
    @http_response_code(200);
    vmlog('FATAL: '.$e['message'].' @ '.$e['file'].':'.$e['line']);
    echo 'OK';
  }
});
set_error_handler(function($n,$s,$f,$l){ vmlog("PHP[$n] $s @ $f:$l"); return false; });
set_exception_handler(function($ex){ vmlog('EX: '.$ex->getMessage().' @ '.$ex->getFile().':'.$ex->getLine()); });

// GET → health
if (($_SERVER['REQUEST_METHOD'] ?? 'GET') === 'GET') {
  @http_response_code(200);
  $health = $BASE.'/health.html';
  if (is_file($health)) { @readfile($health); }
  else { header('Content-Type: text/plain; charset=utf-8'); echo 'OK v89.2'; }
  exit;
}

// config helpers
function vm_cfg(){
  $f=__DIR__.'/storage/config.json';
  if(!is_file($f)) return [];
  $j=@file_get_contents($f);
  $d=@json_decode($j,true);
  return is_array($d)?$d:[];
}

// unified sender
if (!function_exists('vm_send')) {
  function vm_send($chat_id,$text,$kb=null){
    $cfg=vm_cfg(); $t='';
    foreach(['bot_token','token','TOKEN','BOT_TOKEN','telegram_token'] as $k){ if(!empty($cfg[$k])){$t=$cfg[$k]; break;} }
    if(!$t){ vmlog('NO_TOKEN'); return; }
    // normalize reply_markup
    $markup=null;
    if (is_string($kb) && $kb!=='') { $dec=@json_decode($kb,true); if (is_array($dec)) $markup=$dec; }
    elseif (is_array($kb)) { $markup=$kb; }
    if (is_array($markup)){
      if (isset($markup['inline_keyboard']) && !is_array($markup['inline_keyboard'])) {
        $markup['inline_keyboard'] = [ (array)$markup['inline_keyboard'] ];
      }
      if (!isset($markup['inline_keyboard']) && !isset($markup['keyboard'])) {
        $markup = ['inline_keyboard'=>$markup];
      }
    }
    $url='https://api.telegram.org/bot'.$t.'/sendMessage';
    $p=['chat_id'=>(int)$chat_id,'text'=>$text,'parse_mode'=>'HTML'];
    if (is_array($markup)) $p['reply_markup']=json_encode($markup, JSON_UNESCAPED_UNICODE);
    $ctx=stream_context_create(['http'=>['method'=>'POST','header'=>'Content-Type: application/json','content'=>json_encode($p,JSON_UNESCAPED_UNICODE)]]);
    $res=@file_get_contents($url,false,$ctx);
    if($res===false){ vmlog('TG sendMessage failed for chat '.$chat_id); }
  }
}
if (!function_exists('tg_send_html')) {
  function tg_send_html($chat_id,$text,$kb=null){ vm_send($chat_id,$text,$kb); }
}

// owners helpers
function vm_owners(){ $f=__DIR__.'/storage/owners.json'; if(!is_file($f)) return ['ceo_ids'=>[]]; $j=@file_get_contents($f); $d=@json_decode($j,true); return is_array($d)?$d:['ceo_ids'=>[]]; }
function vm_owners_write($d){ $f=__DIR__.'/storage/owners.json'; @mkdir(dirname($f),0777,true); @file_put_contents($f,json_encode($d,JSON_UNESCAPED_UNICODE|JSON_PRETTY_PRINT)); }

// safe load handlers
$handlers = ['functions/telegram.php','handlers/helpers_friendly.php','handlers/owners_helper.php','handlers/dm.php','handlers/dm_advanced.php','handlers/ceo.php','handlers/ceo_plus.php','handlers/ceo_dm_bridge.php','handlers/ceo_dm_bridge_ext.php','handlers/start.php','handlers/accounting.php','handlers/acc_roles.php'];
foreach ($handlers as $h) { $p=__DIR__.'/'.$h; if(is_file($p)) @require_once $p; }

// read update
$raw=@file_get_contents('php://input'); @file_put_contents($BASE.'/storage/logs/latest.json',$raw);
$upd=@json_decode($raw,true); if(!$upd){ @http_response_code(200); echo 'OK'; exit; }

$chat_id=null; $from=null;

// /message
if(isset($upd['message'])){
  $msg=$upd['message']; $chat_id=(int)($msg['chat']['id']??0); $from=$msg['from']??null; $text=trim((string)($msg['text']??''));

  if (strpos($text,'/claimceo')===0){
    $cfg=vm_cfg(); $parts=explode(' ',$text,2); $secret=trim($parts[1]??''); $ok=false;
    if(!empty($cfg['ceo_secret']) && $secret!=='' && hash_equals($cfg['ceo_secret'],$secret)){
      $o=vm_owners(); if(!in_array($chat_id,$o['ceo_ids'],true)){ $o['ceo_ids'][]=$chat_id; vm_owners_write($o); $ok=true; }
    }
    tg_send_html($chat_id,$ok?'✅ شما به‌عنوان مدیرعامل ثبت شدید. /ceo':'❌ کلید نادرست است یا قبلاً ثبت شده‌اید.');
    @http_response_code(200); echo 'OK'; exit;
  }

  if ($text==='/ceo'){
    // open full CEO menu
    if (function_exists('ceo_plus_menu')) ceo_plus_menu($chat_id,$from);
    elseif (function_exists('ceo_menu')) ceo_menu($chat_id,$from);
    else tg_send_html($chat_id,'پنل مدیرعامل نصب نشده است.');
    @http_response_code(200); echo 'OK'; exit;
  }

  if ($text==='/acc'){
    if(function_exists('acc_roles_menu')) acc_roles_menu($chat_id);
    else tg_send_html($chat_id,'پنل حسابداری در دسترس نیست.');
    @http_response_code(200); echo 'OK'; exit;
  }

  if ($text==='/start'){
    // CEO autopanel
    $o=vm_owners();
    if (in_array($chat_id,$o['ceo_ids']??[],true)){
      if (function_exists('ceo_plus_menu')) { ceo_plus_menu($chat_id,$from); @http_response_code(200); echo 'OK'; exit; }
      if (function_exists('ceo_menu')) { ceo_menu($chat_id,$from); @http_response_code(200); echo 'OK'; exit; }
    }
    if(function_exists('start_menu')) start_menu($chat_id,$from);
    else {
      $h=(int)date('G'); if($h>=5&&$h<12)$g='صبح بخیر ☀️'; elseif($h>=12&&$h<14)$g='ظهر بخیر ☀️'; elseif($h>=14&&$h<17)$g='بعدازظهر بخیر 🌤️'; elseif($h>=17&&$h<20)$g='عصر بخیر 🌇'; elseif($h>=20||$h<1)$g='شب بخیر 🌙'; else $g='بامداد بخیر 🌙';
      $txt=$g."\n\nبه ربات ویژن مدیا خوش آمدید! لطفاً نقش خود را انتخاب کنید:";
      $kb=['inline_keyboard'=>[[['text'=>'👤 مشتری هستم','callback_data'=>'start:role:customer']],[['text'=>'🧑‍💼 پرسنل هستم','callback_data'=>'start:role:employee']]]];
      tg_send_html($chat_id,$txt,$kb);
    }
    @http_response_code(200); echo 'OK'; exit;
  }
}

// /callback_query
if(isset($upd['callback_query'])){
  $cb=$upd['callback_query']; $data=(string)($cb['data']??''); $chat_id=(int)($cb['message']['chat']['id']??0); $from=$cb['from']??null;
  $d=str_replace(['|','/'],':',$data);

  if ($d==='ceo:menu'){
    if (function_exists('ceo_plus_menu')) { ceo_plus_menu($chat_id,$from); @http_response_code(200); echo 'OK'; exit; }
  }

  if (strpos($d,'ceo:')===0){
    if(function_exists('ceo_handle')) ceo_handle($d,$chat_id,$from);
    elseif(function_exists('ceo_plus_handle')) ceo_plus_handle($d,$chat_id,$from);
    else tg_send_html($chat_id,'پنل مدیرعامل نصب نیست.');
    @http_response_code(200); echo 'OK'; exit;
  }

  if (strpos($d,'acc:req_roles')===0){
    if(function_exists('acc_roles_handle')) acc_roles_handle($d,$chat_id);
    else tg_send_html($chat_id,'ماژول درخواست نقش نصب نیست.');
    @http_response_code(200); echo 'OK'; exit;
  }

  if (strpos($d,'dm2:')===0){
    if(function_exists('dm2_handle')) dm2_handle($d,$chat_id,$from);
    else if(function_exists('dm2_menu')) dm2_menu($chat_id);
    @http_response_code(200); echo 'OK'; exit;
  }

  if (strpos($d,'dm:')===0){
    if(function_exists('dm_handle')) dm_handle($d,$chat_id);
    elseif(function_exists('department_manager_handle')) department_manager_handle($d,$chat_id);
    elseif(function_exists('handle_dm_callback')) handle_dm_callback($d,$chat_id,$from);
    else tg_send_html($chat_id,'پنل مدیر دپارتمان در دسترس نیست.');
    @http_response_code(200); echo 'OK'; exit;
  }

  if (strpos($d,'start:')===0 || strpos($d,'acc:complete_profile:')===0 || strpos($d,'profile:confirm:')===0 || strpos($d,'employee:contract:')===0 || strpos($d,'acc:act:')===0){
    if(function_exists('start_handle')) start_handle($d,$chat_id,$from);
    else tg_send_html($chat_id,'ماژول شروع نصب نیست.');
    @http_response_code(200); echo 'OK'; exit;
  }

  tg_send_html($chat_id,'دستور ناشناخته.');
  @http_response_code(200); echo 'OK'; exit;
}

@http_response_code(200); echo 'OK';
?>
