<?php
declare(strict_types=1);

require_once __DIR__ . '/../core/utils.php';
require_once __DIR__ . '/../core/telegram.php';
require_once __DIR__ . '/../modules/auth.php';
require_once __DIR__ . '/../handlers/ceo.php'; // برای ceo_menu_main
require_once __DIR__ . '/../config/env.php';

/**
 * منوی شروع
 */
if (!function_exists('start_menu')) {
    function start_menu(int $chat_id): void {
        $kb = kb_inline([
            [ kb_btn('🤝 مشتری هستم', 'start:role:customer'), kb_btn('👤 کارمند هستم', 'start:role:employee') ],
            [ kb_btn('ورود مدیرعامل 👑', 'start:role:ceo') ],
        ]);
        $msg = "من اینجام تا همه‌ی مسیرهای کاری رو شفاف و صمیمیانه برات آسون کنم ✨\n"
             . "یکی از گزینه‌های زیر رو انتخاب کن 👇";
        tg_send_kb_html($chat_id, $msg, $kb);
    }
}

/**
 * روتر متن
 */
if (!function_exists('start_router_text')) {
    function start_router_text(int $chat_id, string $text): bool {
        if (trim($text) === '/start') { start_menu($chat_id); return true; }
        return false;
    }
}

/**
 * روتر کال‌بک
 */
if (!function_exists('start_router_callback')) {
    function start_router_callback(int $chat_id, int $user_id, string $data): bool {
        if (!str_starts($data, 'start:role:')) return false;

        $role = explode(':', $data)[2] ?? '';
        switch ($role) {
            case 'employee':
                auth_handle_role_entry($chat_id, 'employee');
                return true;

            case 'customer':
                auth_handle_role_entry($chat_id, 'customer');
                return true;

            case 'ceo':
                if ($user_id !== CEO_UID) {
                    tg_send_html($chat_id, "❌ فقط مدیرعامل اجازه ورود به این بخش رو داره.");
                } else {
                    tg_send_html($chat_id, "👑 خوش اومدی مدیرعامل عزیز! پنل مدیریتی آماده‌ست.");
                    if (function_exists('ceo_menu_main')) {
                        ceo_menu_main($chat_id);
                    }
                }
                return true;
        }

        return false;
    }
}

/**
 * امضای سازگار با کدی که قبلاً نوشتی
 */
if (!function_exists('start_handle_callback')) {
    function start_handle_callback(int $chat_id, int $user_id, string $data): bool {
        return start_router_callback($chat_id, $user_id, $data);
    }
}

return true;
