<?php
declare(strict_types=1);

/**
 * Vision Media Bot — config.php (Part 1/7)
 * مسیر: /bot/config.php
 * نکته: پس از تأیید شما، بخش‌های 2 تا 7 را می‌فرستم تا فایل کامل شود.
 */

// --- Bot & IDs ---
const BOT_TOKEN     = '7366324571:AAEBRqKRKnaCKhnSqmxfqMwclfOqtvjB_QI';
const BOT_USERNAME  = '@visionmedia_ads_bot';
const CEO_ID        = 894457439;

// --- Hosting & URLs ---
const BASE_URL      = 'https://vernaoil.com/vision_media_bot/bot/index.php'; // entry
const TG_API        = 'https://api.telegram.org/bot' . BOT_TOKEN . '/';

// --- Locale ---
date_default_timezone_set('Asia/Tehran'); // ساعت‌ رسمی شرکت
const USE_JALALI    = true;
const CURRENCY      = 'تومان';

// --- Company Info ---
const COMPANY = [
  'brand'       => 'ویژن مدیا',
  'legal_name'  => 'البرز مدیا دوراندیش',
  'reg_no'      => '۴۲۵۶۳',
  'national_id' => '۱۴۰۱۱۱۲۸۲۲۲',
  'address'     => 'کرج، جهانشهر، میدان سپاه، مجتمع تجاری گلستان',
  'phones'      => ['09331903877','09981381737','02634425880','02191305883'],
  'website'     => 'https://visionmedia.ir',
];

// --- Payments (to Company) ---
const PAYTO = [
  'card'    => '5859838820334401',
  'account' => '03590300021',
  'iban'    => 'IR410180000000103590300021',
  'holder'  => 'شرکت البرز مدیا دور اندیش (ویژن مدیا)',
];

// --- Roles ---
const ROLES = [
  'CEO','ACCOUNTING','DEPT_MANAGER','ADMIN_LEAD',
  'VIDEOGRAPHER','BLOGGER','EDITOR','SCENARIO_WRITER','ADMIN'
];

// --- Penalties & Quotas ---
const PENALTY_PUBLIC_DEFAULT = 250000;                 // جریمه عمومی: ۲۵۰,۰۰۰ تومان
const PENALTY_PRESETS        = [50000,100000,300000,500000,1000000]; // دستی: ۵۰k..۱M
const MONTHLY_OFFISH_QUOTA   = 3;                      // سهمیه ماهانه آفیش
// --- Friendly time-based greetings & helpers ---
function vm_now_greeting(): string {
  $h = (int)date('G'); // Asia/Tehran set above
  if ($h >= 5 && $h < 12)  return "صبح بخیر ☀️";
  if ($h >= 12 && $h < 18) return "وقت بخیر 🌤️";
  if ($h >= 18 && $h < 22) return "عصر به‌خیر 🌇";
  return "شب‌به‌خیر 🌙";
}
function vm_polite_header(string $name = ''): string {
  $greet = vm_now_greeting();
  $who   = trim($name) ? " {$name} عزیز" : " همراه عزیز ویژن‌مدیا";
  return "{$greet}{$who}\n";
}

// --- Seeds: default employees (can be edited later by Accounting) ---
const EMPLOYEE_SEED = [
  [
    'tg_id' => 162160538,
    'full_name' => 'آیدا لطفی',
    'role' => 'DEPT_MANAGER',
    'birth' => '', 'nid' => '', 'address' => '', 'father' => '',
    'iban' => '', 'card' => '',
  ],
  [
    'tg_id' => 287098219,
    'full_name' => 'میثم امجدیان',
    'role' => 'DEPT_MANAGER',
    'birth' => '', 'nid' => '', 'address' => 'کرج، هشتگرد', 'father' => '',
    'iban' => '', 'card' => '',
  ],
  [
    'tg_id' => 1055485720,
    'full_name' => 'شیدا سلیمی سیزکوهی',
    'role' => 'ADMIN_LEAD',
    'birth' => '', 'nid' => '', 'address' => 'کرج، حصارک', 'father' => '',
    'iban' => '', 'card' => '',
  ],
  [
    'tg_id' => 1945384893,
    'full_name' => 'امیرحسین دانش نیا',
    'role' => 'SCENARIO_WRITER',
    'birth' => '1373/04/14', 'nid' => '1741665027',
    'address' => 'کرج، جهانشهر، میدان سپاه، مجتمع گلستان', 'father' => 'علی‌رضا',
    'iban' => '', 'card' => '',
  ],
  [
    'tg_id' => 620344705,
    'full_name' => 'آریا کامی',
    'role' => 'VIDEOGRAPHER',
    'birth' => '', 'nid' => '', 'address' => '', 'father' => '',
    'iban' => '', 'card' => '',
  ],
  [
    'tg_id' => 403409192,
    'full_name' => 'سیده زهرا مجیدی',
    'role' => 'SCENARIO_WRITER',
    'birth' => '', 'nid' => '', 'address' => 'کرج، مصباح', 'father' => '',
    'iban' => '', 'card' => '',
  ],
];

// --- Messages & templates ---
const MESSAGES = [
  'penalty_format' => "#جریمه🔴\n"
    . "🔴تاریخ جریمه: {date}\n"
    . "🔴نام پرسنل: {name}\n"
    . "🔴دلیل جریمه: {reason}\n"
    . "🔴مبلغ جریمه: {amount} " . CURRENCY . "\n"
    . "بنابر دستور مدیریت و حسابداری کاملاً لازم‌الاجرا خواهد بود.",
];

// --- Scheduling & reminders ---
const TASK_WARN_5H_BEFORE   = 5 * 3600;   // 5 hours
const TASK_WARN_1H_BEFORE   = 1 * 3600;   // 1 hour
const CHAT_CLEANUP_SECONDS  = 20 * 60;    // delete reminder msgs each 20m

// --- Billing & late fees ---
const LATE_FEE_PER_DAY      = 150000;     // تومان
const CUSTOMER_REMIND_HOURS = [10, 14, 21]; // ساعت‌های اعلان روز پرداخت (Tehran)

// --- Offish & workflow defaults ---
const FIRST_OFFISH_DEADLINE_DAYS = 7;     // مهلت تعیین اولین آفیش پس از تشکیل تیم
const EDITOR_FIRST_VIDEO_DEADLINE_H = 24; // تدوینگر: 24ساعت برای اولین ویدیو
const SCENARIO_DEADLINE_H = 30;           // سناریونویس: 30ساعت
const UPLOAD_GRACE_H_VG   = 24;           // مهلت ارسال فایل‌های تصویربردار
const REVIEW_GRACE_H_ED   = 24;           // مهلت بررسی تدوینگر پس از دریافت
// --- Store & Services ---
const SERVICES = [
  [
    'id'    => 1,
    'title' => 'ادمین اینستاگرام',
    'desc'  => 'مدیریت کامل پیج اینستاگرام شما شامل تولید محتوا، پاسخ به دایرکت و استوری روزانه.',
    'price' => 5000000, // تومان
    'img'   => 'store/instagram_admin.jpg',
  ],
  [
    'id'    => 2,
    'title' => 'طراحی وب‌سایت',
    'desc'  => 'طراحی سایت اختصاصی، ریسپانسیو و سئو فرندلی با پشتیبانی کامل.',
    'price' => 12000000,
    'img'   => 'store/web_design.jpg',
  ],
  [
    'id'    => 3,
    'title' => 'سئو سایت',
    'desc'  => 'بهینه‌سازی وبسایت برای موتورهای جستجو و افزایش رتبه در گوگل.',
    'price' => 8000000,
    'img'   => 'store/seo.jpg',
  ],
  [
    'id'    => 4,
    'title' => 'طراحی لوگو',
    'desc'  => 'طراحی لوگوی اختصاصی و حرفه‌ای با هویت بصری منحصربه‌فرد.',
    'price' => 2000000,
    'img'   => 'store/logo_design.jpg',
  ],
  [
    'id'    => 5,
    'title' => 'ثبت برند',
    'desc'  => 'مشاوره و انجام کلیه مراحل ثبت برند در اداره مالکیت معنوی.',
    'price' => 7000000,
    'img'   => 'store/brand_register.jpg',
  ],
  [
    'id'    => 6,
    'title' => 'ثبت شرکت',
    'desc'  => 'انجام امور ثبتی انواع شرکت‌ها همراه با مشاوره تخصصی.',
    'price' => 6500000,
    'img'   => 'store/company_register.jpg',
  ],
  [
    'id'    => 7,
    'title' => 'طراحی کاتالوگ',
    'desc'  => 'طراحی کاتالوگ حرفه‌ای برای معرفی کامل محصولات و خدمات شما.',
    'price' => 1500000,
    'img'   => 'store/catalog_design.jpg',
  ],
  [
    'id'    => 8,
    'title' => 'ساخت تیزر تبلیغاتی',
    'desc'  => 'تصویربرداری و تدوین تیزرهای تبلیغاتی خلاقانه برای برند شما.',
    'price' => 10000000,
    'img'   => 'store/teaser.jpg',
  ],
];
// --- Leave (Vacation) Workflow ---
const LEAVE_FLOW = [
  'step1' => 'DEPT_MANAGER',  // ابتدا مدیر دپارتمان
  'step2' => 'ACCOUNTING',    // سپس حسابداری
  'step3' => 'CEO',           // در نهایت مدیرعامل
];

// --- Panels mapping ---
const PANELS = [
  'CEO'             => 'ceo.php',
  'ACCOUNTING'      => 'accounting.php',
  'DEPT_MANAGER'    => 'department.php',
  'ADMIN_LEAD'      => 'admin.php',
  'VIDEOGRAPHER'    => 'employee.php',
  'BLOGGER'         => 'employee.php',
  'EDITOR'          => 'employee.php',
  'SCENARIO_WRITER' => 'employee.php',
  'ADMIN'           => 'employee.php',
  'CUSTOMER'        => 'customer.php',
];

// --- Emoji icons ---
const ICONS = [
  'ceo'        => '👑',
  'accounting' => '🧾',
  'dept'       => '📊',
  'employee'   => '👤',
  'customer'   => '🤝',
  'store'      => '🛍️',
  'services'   => '💼',
  'contract'   => '📑',
  'invoice'    => '💳',
  'calendar'   => '📅',
  'task'       => '✅',
  'penalty'    => '⚠️',
  'bonus'      => '🎁',
  'offish'     => '📷',
  'scenario'   => '📝',
  'editor'     => '🎬',
  'blogger'    => '📱',
  'admin'      => '🛡️',
];

// Helper for icons
function icon(string $k): string {
  return ICONS[$k] ?? '';
}
// --- Default messages for UI ---
const UI_MSG = [
  'welcome_employee' =>
    "🌟 {greet}\n\n"
    . "به خانواده بزرگ «ویژن مدیا» خوش اومدی! 🎉\n"
    . "از این لحظه تو بخشی از تیم حرفه‌ای ما هستی و می‌تونی از پنل اختصاصی‌ات کارهات رو مدیریت کنی.\n\n"
    . "هر وظیفه‌ای که بهت محول بشه اینجا میاد؛ "
    . "پس حتماً نوتیفیکیشن‌هات رو روشن نگه دار 💡\n\n"
    . "موفق باشی {name} عزیز 💪",

  'welcome_customer' =>
    "🤝 {greet}\n\n"
    . "خوشحالیم که «ویژن مدیا» رو برای رشد برندت انتخاب کردی 🌹\n"
    . "از این لحظه پنل مشتری برات فعاله؛ "
    . "اینجا می‌تونی قراردادها، سرویس‌ها، پرداخت‌ها و فروشگاه خدمات ما رو ببینی.\n\n"
    . "هر سوالی داشتی تیم پشتیبانی ما کنارت هست ❤️",

  'welcome_ceo' =>
    "👑 {greet}\n\n"
    . "مدیرعامل عزیز، به پنل مدیریتی جامع «ویژن مدیا» خوش اومدی.\n"
    . "اینجا همه‌چیز زیر دستت آماده‌ست: پرسنل، مشتریان، قراردادها، فاکتورها، جریمه‌ها و گزارش‌ها.\n\n"
    . "با یک لمس همه‌چیز رو کنترل کن ✨",

  'penalty_auto' =>
    "⚠️ یک جریمه خودکار برای {name} ثبت شد.\n"
    . "علت: {reason}\n"
    . "مبلغ: {amount} " . CURRENCY,

  'reminder_task' =>
    "⏰ یادآوری وظیفه\n"
    . "۵ ساعت یا ۱ ساعت دیگه مهلتت تموم میشه!\n"
    . "عنوان وظیفه: {task}\n"
    . "لطفاً به موقع انجام بده 💪",
];

// --- Store presentation ---
const STORE_UI = [
  'header' =>
    "🛍️ فروشگاه جذاب ویژن مدیا\n"
    . "اینجا می‌تونی سرویس‌های حرفه‌ای ما رو ببینی و مستقیم خرید کنی.\n\n",
  'footer' =>
    "💳 برای پرداخت، گزینه کارت به کارت فعال میشه و رسیدت رو همینجا آپلود می‌کنی.\n"
    . "تیم حسابداری بررسی و تایید می‌کنه.\n\n"
    . "با ویژن مدیا همیشه یک قدم جلوتر باش ✨",
];
// --- Reminders texts for payments ---
const PAYMENT_MSG = [
  'prepay' =>
    "💰 پیش‌پرداخت شما ثبت شد.\n"
    . "مبلغ واریزی: {amount} " . CURRENCY . "\n"
    . "مانده فاکتور: {remain} " . CURRENCY . "\n"
    . "تاریخ سررسید پرداخت باقی‌مانده: {date}\n\n"
    . "خواهشمندیم در موعد مقرر تسویه کنید 🙏",

  'remind_due' =>
    "⏰ یادآوری پرداخت\n"
    . "مانده فاکتور شما: {remain} " . CURRENCY . "\n"
    . "مهلت: {date}\n"
    . "لطفاً تا پایان امروز اقدام کنید 🌹",

  'late_fee' =>
    "⚠️ پرداخت شما به تعویق افتاده!\n"
    . "مانده: {remain} " . CURRENCY . "\n"
    . "جریمه دیرکرد امروز: +" . LATE_FEE_PER_DAY . " " . CURRENCY . "\n"
    . "جمع بدهی تا این لحظه: {total} " . CURRENCY,
];

// --- Reminder logic for tasks ---
const TASK_REMINDERS = [
  '5h' => "⏳ تنها ۵ ساعت دیگه برای انجام وظیفه باقی مونده!\n"
        . "کار: {task}\n"
        . "لطفاً سریع‌تر اقدام کن 💪",
  '1h' => "⏳ تنها ۱ ساعت دیگه برای انجام وظیفه باقی مونده!\n"
        . "کار: {task}\n"
        . "وقت رو از دست نده 🔥",
  'done_btn' => "✅ انجام شد",
];

// --- Auto clean rules ---
const AUTO_DELETE_INTERVAL = 20 * 60; // 20 دقیقه
// --- Logging ---
const LOG_DIR = __DIR__ . '/logs';
if (!is_dir(LOG_DIR)) @mkdir(LOG_DIR, 0775, true);
ini_set('log_errors', '1');
ini_set('error_log', LOG_DIR . '/php-error.log');

// --- Storage paths ---
const STORAGE = [
  'users'      => __DIR__ . '/storage/users.json',
  'customers'  => __DIR__ . '/storage/customers.json',
  'contracts'  => __DIR__ . '/storage/contracts.json',
  'invoices'   => __DIR__ . '/storage/invoices.json',
  'receipts'   => __DIR__ . '/storage/receipts.json',
  'penalties'  => __DIR__ . '/storage/penalties.json',
  'tasks'      => __DIR__ . '/storage/tasks.json',
  'schedules'  => __DIR__ . '/storage/schedules.json',
  'role_reqs'  => __DIR__ . '/storage/role_requests.json',
];

// --- End of config.php ---
