<?php
declare(strict_types=1);

/**
 * Vision Media Bot — handlers/accounting.php (FULL)
 * پنل حسابداری: فروشگاه، فاکتورها، یادآوری‌ها/جریمه دیرکرد، مدیریت مشتریان،
 * تایید/رد «درخواست نقش»، و دیسپچر مکالمه acc_conv_dispatch_text
 */

/*======================== منو و روتینگ پایه ========================*/

function acc_menu(int $chat_id): void {
    $rows = [
        [kb_btn("🧾 فاکتورها", "acc:inv"), kb_btn("🛍️ فروشگاه", "acc:store")],
        [kb_btn("🤝 مشتریان", "acc:cust"), kb_btn("👤 نقش‌ها", "acc:role:reqs")],
        [kb_btn("📊 گزارش", "acc:report")]
    ];
    tg_send_kb_html($chat_id, "🧾 <b>پنل حسابداری</b>", kb_inline($rows));
}


function acc_router(int $chat_id, int $uid, array $user, array $parts): void {
    $act = $parts[1] ?? '';

    if ($act === 'inv') {                       // فاکتورها
        $sub = $parts[2] ?? '';
        if ($sub === 'list') { $cid=(int)($parts[3]??0); acc_invoices_list($chat_id,1,$cid); return; }
        if ($sub === 'new')  { $cid=(int)($parts[3]??0); acc_invoice_new_flow($chat_id,$cid); return; }
        acc_invoices_list($chat_id); return;
    }

    if ($act === 'store') {                     // فروشگاه
        $sub = $parts[2] ?? '';
        if     ($sub === 'view')  { acc_store_view($chat_id,(int)($parts[3]??0)); return; }
        elseif ($sub === 'share') { acc_store_share($chat_id,(int)($parts[3]??0)); return; }
        acc_store_menu($chat_id); return;
    }

    if ($act === 'cust') {                      // مشتریان
        $sub = $parts[2] ?? '';
        if ($sub === 'view') { acc_customer_view($chat_id,(int)($parts[3]??0)); return; }
        acc_customers_menu($chat_id); return;
    }

    if ($act === 'role') {                      // درخواست‌های نقش
        $sub = $parts[2] ?? '';
        if ($sub === 'reqs')   { acc_role_reqs($chat_id); return; }
        if ($sub === 'approve'){ $ap=$parts[3]??''; $role=$parts[4]??''; if($ap&&$role) acc_role_approve($ap,$role); return; }
        if ($sub === 'reject') { $ap=$parts[3]??''; if($ap) acc_role_reject($ap); return; }
        acc_role_reqs($chat_id); return;
    }

    if ($act === 'report') { acc_report($chat_id); return; }

    acc_menu($chat_id);
}

/*======================== فاکتورها ========================*/

function acc_invoices_list(int $chat_id, int $page=1, ?int $cust_id=null): void {
    $invoices = storage_load(STORAGE['invoices']);
    if ($cust_id) $invoices = array_values(array_filter($invoices, fn($i)=>(int)($i['cust']??0)===$cust_id));
    if (!$invoices) { tg_send_html($chat_id, "هیچ فاکتوری ثبت نشده."); return; }

    $msg = "📄 <b>لیست فاکتورها</b>\n\n";
    foreach ($invoices as $inv) {
        $msg .= "🔹 {$inv['id']} — ".money((int)$inv['amount'])."\n";
        $msg .= "وضعیت: ".htmlspecialchars($inv['status'])." | تاریخ: ".dt_jalali((int)$inv['time'])."\n";
        if (!empty($inv['due'])) $msg .= "سررسید: ".htmlspecialchars((string)$inv['due'])."\n";
        $msg .= "\n";
    }
    tg_send_html($chat_id, $msg);
}

function acc_invoice_add(int $cust_id, int $amount, string $status='prepay', string $due=''): void {
    $cust = user_get($cust_id) ?? ['id'=>$cust_id,'full_name'=>'مشتری'];
    customer_payment_add($cust, $amount, $status, $due);
    tg_send_success($cust_id,
        "🧾 فاکتور جدید ثبت شد.\n"
        ."مبلغ: ".money($amount)."\n"
        ."وضعیت: {$status}".($due ? "\nسررسید مانده: {$due}" : '')
    );
}

/* ساخت فلو «فاکتور جدید» (paid | prepay + due) */
function acc_invoice_new_flow(int $chat_id, int $cust_id): void {
    conv_start($chat_id, 'acc_new_inv', 0, ['cust_id'=>$cust_id]);
    tg_send_html($chat_id, "🧾 مبلغ فاکتور را به تومان ارسال کنید (فقط عدد).");
}
function acc_invoice_new_flow_text(int $chat_id, int $uid, string $text): bool {
    $s = conv_get($uid); if (!$s || ($s['flow']??'')!=='acc_new_inv') return false;
    $step = (int)($s['step']??0); $data = $s['data']??[];

    if ($step === 0) {
        $amount = (int)preg_replace('/\D+/', '', $text);
        if ($amount <= 0) { tg_send_alert($chat_id, "مبلغ نامعتبر."); return true; }
        conv_start($uid,'acc_new_inv',1,['cust_id'=>$data['cust_id'],'amount'=>$amount]);
        tg_send_html($chat_id,"💳 وضعیت پرداخت را مشخص کنید:\n- <b>prepay</b> (پیش‌پرداخت)\n- <b>paid</b> (تسویه کامل)");
        return true;
    }
    if ($step === 1) {
        $status = strtolower(trim($text));
        if (!in_array($status,['prepay','paid'])) { tg_send_alert($chat_id,"فقط prepay یا paid را بفرست."); return true; }
        if ($status==='prepay') {
            conv_start($uid,'acc_new_inv',2,['cust_id'=>$data['cust_id'],'amount'=>$data['amount'],'status'=>$status]);
            tg_send_html($chat_id,"📅 تاریخ سررسید مانده را به صورت YYYY-MM-DD ارسال کن (مثال: 2025-09-10).");
            return true;
        }
        acc_invoice_add((int)$data['cust_id'],(int)$data['amount'],'paid','');
        conv_clear($uid); tg_send_success($chat_id,"فاکتور تسویه‌شده ثبت شد."); return true;
    }
    if ($step === 2) {
        $due = trim($text); $cust_id=(int)$data['cust_id'];
        acc_invoice_add($cust_id,(int)$data['amount'],'prepay',$due);
        conv_clear($uid);
        tg_send_success($chat_id,"فاکتور پیش‌پرداخت با سررسید {$due} ثبت شد.");
        $cust = user_get($cust_id) ?? ['id'=>$cust_id,'full_name'=>'مشتری'];
        tg_send_html($cust_id,"🧾 فاکتور شما صادر شد.\nمبلغ کل: ".money((int)$data['amount'])."\nسررسید مانده: {$due}");
        return true;
    }
    return false;
}

/*======================== فروشگاه ========================*/

function acc_store_menu(int $chat_id): void {
    if (empty(SERVICES)) { tg_send_html($chat_id, "هیچ خدمتی تعریف نشده."); return; }
    $msg = "🛍️ <b>فروشگاه خدمات</b>\n";
    $rows = [];
    foreach (SERVICES as $s) {
        $msg .= "• <b>{$s['title']}</b> — ".money((int)$s['price'])."\n";
        $rows[] = [kb_btn("مشاهده «{$s['title']}»", "acc:store:view:".$s['id'])];
    }
    tg_send_kb_html($chat_id,$msg,kb_inline($rows));
}
function acc_store_view(int $chat_id, int $sid): void {
    $svc = arr_find(SERVICES, fn($x)=> (int)$x['id']===$sid);
    if (!$svc) { tg_send_alert($chat_id,"سرویس پیدا نشد."); return; }
    $price = money((int)$svc['price']);
    $msg = "🛍️ <b>{$svc['title']}</b>\n\n{$svc['desc']}\n\n💵 قیمت: <b>{$price}</b>\n\n"
         . "اطلاعات پرداخت کارت‌به‌کارت:\n"
         . "🔴 کارت: <code>".PAYTO['card']."</code>\n"
         . "🔵 حساب: <code>".PAYTO['account']."</code>\n"
         . "🟣 شبا: <code>".PAYTO['iban']."</code>\n"
         . "⚪ به نام: ".PAYTO['holder'];
    $rows = [
        [kb_btn("ارسال به مشتری…", "acc:store:share:".$sid)],
        [kb_btn("بازگشت", "acc:store")],
    ];
    tg_send_kb_html($chat_id,$msg,kb_inline($rows));
}
function acc_store_share(int $chat_id, int $sid): void {
    tg_send_html($chat_id, "👤 <b>آی‌دی عددی مشتری</b> را ارسال کنید تا اطلاعات پرداخت سرویس {$sid} برای او ارسال شود.\nمثال: <code>123456789</code>");
    conv_start($chat_id,'acc_share_pay',0,['sid'=>$sid]);
}

/*======================== مشتریان ========================*/

function acc_customers_menu(int $chat_id): void {
    $custs = users_by_role('CUSTOMER');
    if (!$custs) { tg_send_html($chat_id,"هیچ مشتری ثبت نشده."); return; }
    $msg="🤝 <b>مدیریت مشتریان</b>\n";
    $rows=[];
    foreach ($custs as $c) { $rows[]=[kb_btn(($c['full_name']??$c['id'])." (".$c['id'].")","acc:cust:view:".$c['id'])]; }
    tg_send_kb_html($chat_id,$msg,kb_inline($rows));
}
function acc_customer_view(int $chat_id, int $cust_id): void {
    $u=user_get($cust_id); if(!$u){ tg_send_alert($chat_id,"مشتری پیدا نشد."); return; }
    $invs=customer_invoices($cust_id);
    $msg="👤 <b>{$u['full_name']}</b> — ID: {$u['id']}\n"
        ."تعداد فاکتورها: ".count($invs)."\n";
    $rows=[
        [kb_btn("ثبت فاکتور جدید", "acc:inv:new:".$cust_id)],
        [kb_btn("مشاهده فاکتورها", "acc:inv:list:".$cust_id)],
        [kb_btn("بازگشت", "acc:cust")],
    ];
    tg_send_kb_html($chat_id,$msg,kb_inline($rows));
}

/*======================== گزارش ========================*/

function acc_report(int $chat_id): void {
    $invs = storage_load(STORAGE['invoices']);
    $pens = storage_load(STORAGE['penalties']);
    $total = 0; foreach ($invs as $i) $total += (int)($i['amount']??0);
    $msg = "📊 <b>گزارش سریع حسابداری</b>\n\n"
         . "تعداد فاکتورها: ".count($invs)."\n"
         . "جمع مبالغ: ".money((int)$total)."\n"
         . "تعداد جریمه‌ها: ".count($pens)."\n";
    tg_send_html($chat_id,$msg);
}

/*======================== دیرکرد و یادآوری‌ها ========================*/

function inv_due_ts($due): int {
    if (is_numeric($due)) return (int)$due;
    $ts = strtotime((string)$due); return $ts ? $ts : time();
}
function acc_reminders_run(): void {
    $invs = storage_load(STORAGE['invoices']); $changed=false;
    foreach ($invs as &$inv) {
        if (($inv['status']??'')!=='prepay') continue;
        $cust = user_get((int)($inv['cust']??0)); if(!$cust) continue;

        $due_ts = inv_due_ts($inv['due']??'');
        $today  = strtotime(date('Y-m-d'));
        $nowH   = (int)date('G');

        // یک روز مانده
        if ($today === ($due_ts - 86400)) {
            $msg = str_replace(['{remain}','{date}'],
                               [number_format((int)$inv['amount']), date('Y-m-d',$due_ts)],
                               PAYMENT_MSG['remind_due']);
            tg_send_html((int)$cust['id'], $msg);
        }
        // روز سررسید در 10/14/21
        if ($today === $due_ts && in_array($nowH, CUSTOMER_REMIND_HOURS, true)) {
            customer_invoice_remind($inv, $cust);
        }
        // گذشته از سررسید: هر شب +150k
        if ($today > $due_ts && (int)date('H')===0) {
            $inv['amount'] = (int)($inv['amount']??0) + (int)LATE_FEE_PER_DAY;
            $total = number_format((int)$inv['amount']);
            $msg = str_replace(['{remain}','{total}'],[$total,$total],PAYMENT_MSG['late_fee']);
            tg_send_html((int)$cust['id'], $msg);
            $changed=true;
        }
    }
    if ($changed) storage_save(STORAGE['invoices'], $invs);
}

/*======================== درخواست‌های نقش ========================*/

function acc_role_reqs(int $chat_id): void {
    $reqs = approvals_by_type('role_req');
    $reqs = array_values(array_filter($reqs, fn($r)=>($r['status']??'')==='pending'));
    if (!$reqs) { tg_send_html($chat_id, "هیچ درخواست نقشی در انتظار نیست."); return; }

    foreach ($reqs as $r) {
        $uid = (int)($r['target']??0);
        $u   = user_get($uid) ?: ['id'=>$uid,'full_name'=>'کاربر'];
        $want= $r['data']['want'] ?? '-';
        $msg = "📝 درخواست نقش\n"
             . "کاربر: ".($u['full_name'] ?? $uid)." ({$uid})\n"
             . "درخواست: <b>{$want}</b>\n"
             . "Approval: {$r['id']}";

        if ($want === 'customer') {
            $rows = [[ kb_btn("تایید مشتری ✅", "acc:role:approve:{$r['id']}:CUSTOMER"),
                       kb_btn("رد ❌",          "acc:role:reject:{$r['id']}") ]];
        } else {
            $rows = [
                [ kb_btn("مدیر دپارتمان", "acc:role:approve:{$r['id']}:DEPT_MANAGER") ],
                [ kb_btn("ادمین ارشد",   "acc:role:approve:{$r['id']}:ADMIN_LEAD") ],
                [ kb_btn("ادمین",        "acc:role:approve:{$r['id']}:ADMIN") ],
                [ kb_btn("تصویربردار",   "acc:role:approve:{$r['id']}:VIDEOGRAPHER") ],
                [ kb_btn("بلاگر",        "acc:role:approve:{$r['id']}:BLOGGER") ],
                [ kb_btn("تدوینگر",      "acc:role:approve:{$r['id']}:EDITOR") ],
                [ kb_btn("سناریونویس",   "acc:role:approve:{$r['id']}:SCENARIO_WRITER") ],
                [ kb_btn("رد ❌",        "acc:role:reject:{$r['id']}") ],
            ];
        }
        tg_send_kb_html($chat_id,$msg,kb_inline($rows));
    }
}
function acc_role_approve(string $appr_id, string $role): void {
    $a = approval_get($appr_id); if(!$a) return;
    $uid = (int)($a['target']??0);
    user_assign_role($uid, $role);
    approval_set_status($appr_id,'approved',0,"set role={$role}");
    tg_send_success($uid, "پرونده‌ات تایید شد ✅\nنقش شما: ".user_role_label(['role'=>$role]));
    tg_send_html(CEO_ID, "✅ نقش کاربر {$uid} به «{$role}» ست شد.");
}
function acc_role_reject(string $appr_id): void {
    $a = approval_get($appr_id); if(!$a) return;
    $uid = (int)($a['target']??0);
    approval_set_status($appr_id,'rejected',0,"rejected");
    tg_send_alert($uid, "پرونده‌ات توسط حسابداری رد شد ❌");
}

/*======================== دیسپچر مکالمه حسابداری ========================*/
/* این تابع توسط index.php فراخوانی می‌شود؛ همیشه باید موجود باشد. */
function acc_conv_dispatch_text(int $chat_id, int $uid, string $text): bool {
    $s = conv_get($uid); if (!$s) return false;
    $flow = $s['flow'] ?? '';

    // فلو فاکتور جدید
    if ($flow === 'acc_new_inv') {
        return acc_invoice_new_flow_text($chat_id, $uid, $text);
    }

    // فلو ارسال اطلاعات پرداخت سرویس به مشتری (دریافت آی‌دی مشتری)
    if ($flow === 'acc_share_pay') {
        $sid = (int)($s['data']['sid'] ?? 0);
        $cust_id = (int)preg_replace('/\D+/', '', $text);
        if ($cust_id <= 0) { tg_send_alert($chat_id,"آی‌دی عددی نامعتبر."); return true; }

        $svc = arr_find(SERVICES, fn($x)=> (int)$x['id']===$sid);
        if (!$svc) { tg_send_alert($chat_id,"سرویس پیدا نشد."); conv_clear($uid); return true; }

        $price = money((int)$svc['price']);
        $msg = "🛍️ <b>{$svc['title']}</b>\n\n{$svc['desc']}\n\n"
             . "💵 قیمت: <b>{$price}</b>\n\n"
             . "اطلاعات پرداخت کارت‌به‌کارت:\n"
             . "🔴 کارت: <code>".PAYTO['card']."</code>\n"
             . "🔵 حساب: <code>".PAYTO['account']."</code>\n"
             . "🟣 شبا: <code>".PAYTO['iban']."</code>\n"
             . "⚪ به نام: ".PAYTO['holder']."\n\n"
             . "لطفاً پس از پرداخت، رسید را در همین گفتگو ارسال کنید ❤️";
        tg_send_html($cust_id, $msg);
        tg_send_success($chat_id, "ارسال شد ✅");
        conv_clear($uid);
        return true;
    }

    return false;
}
