<?php
declare(strict_types=1);
require_once __DIR__ . '/../functions/telegram.php';
require_once __DIR__ . '/../functions/utils.php';
require_once __DIR__ . '/../functions/storage.php';
require_once __DIR__ . '/../functions/approvals.php';

function acc_menu(int $chat_id): void {
    $rows = [
        [ kb_btn(icon('contract')." قراردادها", 'acc:contracts'), kb_btn(icon('invoice')." فاکتورها", 'acc:invoices') ],
        [ kb_btn("انتصاب مشتری به مدیر دپارتمان 👥", 'acc:assign'), kb_btn("تأیید تخلفات 👮‍♂️", 'acc:approvals') ],
        [ kb_btn("مدیریت فروشگاه 🛍️", 'acc:store'), kb_btn("گزارش حقوق/کسورات 💼", 'acc:payroll') ],
        [ kb_btn("تنظیم جریمه دیرکرد 💸", 'acc:latefee'), kb_btn("لیست مشتریان 🗂️", 'acc:customers') ],
        [ kb_btn(icon('back')." بازگشت", 'ceo:menu') ]
    ];
    tg_send_html($chat_id, icon('accounting')." <b>پنل حسابداری</b>", $rows);
}

function acc_handle(string $data, int $chat_id): void {
    if ($data === 'acc:menu') { acc_menu($chat_id); return; }
    if ($data === 'acc:contracts') {
        $items = contracts_all();
        $txt = "<b>قراردادها:</b>\n".($items? json_encode($items, JSON_UNESCAPED_UNICODE|JSON_PRETTY_PRINT):"خالی");
        $kb = [[ kb_btn(icon('edit')." ثبت قرارداد نمونه", 'acc:contracts:add') ]];
        tg_send_html($chat_id, friendly_greeting()."\n\n".$txt, $kb);
    } elseif ($data === 'acc:contracts:add') {
        $items = contracts_all();
        $items[] = ['id'=>count($items)+1,'customer_chat_id'=>123,'title'=>'نمونه قرارداد','date'=>date('Y-m-d')];
        contracts_save($items);
        tg_send_html($chat_id, friendly_greeting()."\n\n".icon('ok')." قرارداد نمونه ثبت شد.");
    }
    acc_handle_invoice_cb($data,$chat_id);
    if ($data === 'acc:invoices') {
        $items = invoices_all();
        $txt = "<b>فاکتورها:</b>\n".($items? json_encode($items, JSON_UNESCAPED_UNICODE|JSON_PRETTY_PRINT):"خالی");
        $kb = [[ kb_btn(icon('edit')." صدور فاکتور نمونه", 'acc:invoices:add') ]];
        tg_send_html($chat_id, friendly_greeting()."\n\n".$txt, $kb);
    } elseif ($data === 'acc:invoices:add') {
        $items = invoices_all();
        $items[] = ['id'=>count($items)+1,'customer_chat_id'=>123,'amount'=>2500000,'no'=>'INV-'.(count($items)+1),'date'=>date('Y-m-d')];
        invoices_save($items);
        tg_send_html($chat_id, friendly_greeting()."\n\n".icon('ok')." فاکتور نمونه صادر شد.");
    }
}


function acc_invoice_detail(int $chat_id, int $id): void {
    $list = invoices_all();
    foreach ($list as $it) if ((int)$it['id']===$id) {
        $due = $it['due_date'] ?? '-';
        $bal = (int)($it['balance'] ?? 0);
        $txt = "<b>فاکتور #" . $id . "</b>\nمبلغ: ".($it['amount']??0)."\nپرداخت: ".($it['paid']??0)."\nمانده: ".$bal."\nسررسید: ".$due;
        $kb = [
            [ kb_btn("تأیید پرداخت کامل ✅", "acc:invoice:paid:".$id) ],
            [ kb_btn("پیش‌پرداخت/مانده ✍️", "acc:invoice:mark_prepay:".$id) ],
        ];
        tg_send_html($chat_id, $txt, $kb); return;
    }
    tg_send_html($chat_id, "فاکتور یافت نشد.");
}

function acc_handle_invoice_cb(string $data, int $chat_id): void {
    if (strpos($data,'acc:invoice:paid:')===0) {
        $id = (int)substr($data, strstrlen('acc:invoice:paid:'));
        $list = invoices_all();
        foreach ($list as &$it) if ((int)$it['id']===$id) { $it['paid'] = (int)$it['amount']; $it['balance']=0; $it['status']='paid'; }
        invoices_save($list);
        tg_send_html($chat_id, "✅ پرداخت کامل شد.");
    } elseif (strpos($data,'acc:invoice:mark_prepay:')===0) {
        $id = (int)substr($data, strstrlen('acc:invoice:mark_prepay:'));
        $list = invoices_all();
        foreach ($list as &$it) if ((int)$it['id']===$id) {
            $it['status']='partial'; $it['paid'] = (int)($it['paid']??0); $it['balance'] = max(0, (int)$it['amount'] - (int)$it['paid']);
            $it['due_date'] = date('Y-m-d', time() + 86400*3); // default +3d; قابل ویرایش در نسخه بعد
        }
        invoices_save($list);
        tg_send_html($chat_id, "✍️ پیش‌پرداخت ثبت شد. مانده/سررسید تنظیم شد.");
    }
}


function acc_customer_assign_dm(int $chat_id, int $customer_chat_id, int $dm_id): void {
    // notify DM; create team task due in 7 days for first offish
    tg_send_html($dm_id, "مشتری جدید منتصب شد (#{$customer_chat_id}). لطفاً تیم را تشکیل بده و اولین آفیش را ظرف ۷ روز تنظیم کن.");
    $due = time() + 7*24*3600;
    task_create("تشکیل تیم و تنظیم اولین آفیش برای مشتری {$customer_chat_id}", $dm_id, $due, 'first_offish', ['customer_id'=>$customer_chat_id]);
    tg_send_html($chat_id, "✅ مشتری به مدیر دپارتمان منتصب شد و وظیفهٔ ۷روزه ایجاد گردید.");
}


require_once __DIR__ . '/../functions/approvals.php';
require_once __DIR__ . '/../functions/payroll.php';

function acc_approvals_menu(int $chat_id): void {
    $items = appr_list('pending');
    $out = [];
    foreach ($items as $it) if (($it['type']??'')==='penalty') $out[] = $it;
    if (!$out) { tg_send_html($chat_id, "درخواست تأیید جریمه‌ای وجود ندارد."); return; }
    foreach ($out as $it) {
        $p = $it['payload'] ?? [];
        $txt = "📄 #جریمه\n"
             ."🔴شناسه: ".$it['id']."\n"
             ."🔴نام پرسنل (ID): ".$p['user_id']."\n"
             ."🔴دلیل: ".$p['reason']."\n"
             ."🔴مبلغ: ".number_format((int)$p['amount'])."\n";
        $kb = [[ kb_btn("تأیید حسابداری ✅", "acc:appr:ok:".$it['id']), kb_btn("رد ❌", "acc:appr:no:".$it['id']) ]];
        tg_send_html($chat_id, $txt, $kb);
        if (!empty($p['photo'])) {
            tg_api('sendPhoto', ['chat_id'=>$chat_id, 'photo'=>$p['photo'], 'caption'=>"مستند تخلف #".$it['id']]);
        }
    }
}
function acc_approvals_handle(string $data, int $chat_id): bool {
    if ($data==='acc:approvals') { acc_approvals_menu($chat_id); return true; }
    if (strpos($data,'acc:appr:ok:')===0) {
        $id = (int)substr($data, strstrlen('acc:appr:ok:'));
        $list = approvals_all();
        foreach (($list['items']??[]) as &$it) if ((int)$it['id']===$id) $it['status']='acc_ok';
        approvals_save($list);
        tg_send_html($chat_id, "ثبت شد: ارسال برای مدیرعامل.");
        tg_send_html(CEO_ID, "⏳ جریمه #{$id} در انتظار تأیید نهایی مدیرعامل.");
        return true;
    }
    if (strpos($data,'acc:appr:no:')===0) {
        $id = (int)substr($data, strstrlen('acc:appr:no:'));
        $list = approvals_all();
        foreach (($list['items']??[]) as &$it) if ((int)$it['id']===$id) $it['status']='rejected';
        approvals_save($list);
        tg_send_html($chat_id, "رد شد.");
        return true;
    }
    return false;
}


require_once __DIR__ . '/../functions/store.php';
require_once __DIR__ . '/../functions/users.php';
require_once __DIR__ . '/../functions/offish.php';
require_once __DIR__ . '/../functions/tasks.php';




function acc_store_list(int $chat_id): void {
    store_seed_if_empty();
    $items = store_list();
    if (!$items) { tg_send_html($chat_id, "فروشگاه خالی است.", [[kb_btn("➕ افزودن خدمت", "acc:store:add")], [kb_btn(icon('back')." بازگشت", "acc:menu")]]); return; }
    $txt = "🛍️ <b>فهرست خدمات</b>\n";
    $kb = [];
    foreach ($items as $it) {
        $state = !empty($it['active']) ? "فعال ✅" : "غیرفعال ⛔️";
        $txt .= "— #{$it['id']} «{$it['name']}» — قیمت: ".number_format((int)$it['price'])." — {$state}\n";
        $kb[] = [ kb_btn("مدیریت #".$it['id'], "acc:store:item:".$it['id']) ];
    }
    $kb[] = [ kb_btn("➕ افزودن خدمت", "acc:store:add") ];
    $kb[] = [ kb_btn(icon('back')." بازگشت", "acc:menu") ];
    tg_send_html($chat_id, $txt, $kb);
}
function acc_store_item(int $chat_id, int $id): void {
    $it = store_get($id); if (!$it) { tg_send_html($chat_id, "یافت نشد."); return; }
    $state = !empty($it['active']) ? "✅" : "⛔️";
    $txt = "<b>#{$it['id']} — {$it['name']}</b>\nقیمت: ".number_format((int)$it['price'])."\nوضعیت: {$state}\nتوضیح: ".($it['desc']??'-');
    $kb = [
        [ kb_btn("ویرایش نام ✏️", "acc:store:edit:name:".$id), kb_btn("ویرایش قیمت 💵", "acc:store:edit:price:".$id) ],
        [ kb_btn("ویرایش توضیح 📝", "acc:store:edit:desc:".$id), kb_btn("ویرایش عکس 🖼️", "acc:store:edit:img:".$id) ],
        [ kb_btn("تغییر وضعیت فعال/غیرفعال 🔁", "acc:store:toggle:".$id) ],
        [ kb_btn(icon('back')." فهرست", "acc:store:list") ]
    ];
    tg_send_html($chat_id, $txt, $kb);
    if (!empty($it['img'])) tg_api('sendPhoto', ['chat_id'=>$chat_id,'photo'=>$it['img'],'caption'=>$it['name']]);
}
function acc_store_add(int $chat_id): void {
    $id = store_add_service("خدمت جدید", 100000, "توضیح نمونه", "");
    $kb = [
        [ kb_btn("مدیریت آیتم #".$id, "acc:store:item:".$id) ],
        [ kb_btn(icon('back')." فهرست", "acc:store:list") ]
    ];
    tg_send_html($chat_id, "✅ خدمت جدید ایجاد شد (#{$id}).", $kb);
}

function acc_store_toggle(int $chat_id, int $id): void {
    $it = store_get($id); if (!$it) { tg_send_html($chat_id, "یافت نشد."); return; }
    $new = empty($it['active']);
    store_update($id, ['active'=>$new]);
    tg_send_html($chat_id, "وضعیت به ".($new?"فعال ✅":"غیرفعال ⛔️")." تغییر کرد.", [[kb_btn("↩️ برگشت به آیتم", "acc:store:item:".$id)]]);
}

require_once __DIR__ . '/../functions/penalties_flow.php'; // reuse state_get/state_put/state_clear
function acc_store_begin_edit(int $chat_id, int $id, string $field): void {
    $st = state_get($chat_id);
    $st = ['flow'=>'acc_store_edit','step'=>$field,'data'=>['id'=>$id]];
    state_put($chat_id, $st);
    $label = ['name'=>'نام جدید را بنویس','price'=>'قیمت جدید (عدد)','desc'=>'توضیح جدید','img'=>'لینک عکس (URL) یا file_id'];
    tg_send_html($chat_id, "✏️ ".$label[$field]);
}
function acc_store_handle_edit_message(int $chat_id, array $msg): bool {
    $st = state_get($chat_id);
    if (($st['flow'] ?? '') !== 'acc_store_edit') return false;
    $field = $st['step'] ?? ''; $id = (int)($st['data']['id'] ?? 0);
    $val = trim($msg['text'] ?? '');
    if ($field==='price') { $val = preg_replace('/\D+/','',$val); $val = $val?:'0'; }
    store_update($id, [$field=>$val]); state_clear($chat_id);
    tg_send_html($chat_id, "✅ به‌روزرسانی شد.", [[kb_btn("↩️ برگشت به آیتم", "acc:store:item:".$id)]]);
    return true;
}


require_once __DIR__ . '/../functions/reports.php';

function acc_emp_reports(int $chat_id): void {
    $u = users_all();
    $kb = [];
    foreach ($u as $user) {
        if (($user['role'] ?? '')==='employee' || ($user['role'] ?? '')==='dept_manager' || ($user['role'] ?? '')==='accountant') {
            $label = ($user['first_name'] ?? 'بدون‌نام') . " — " . ($user['role'] ?? '-');
            $kb[] = [ kb_btn($label, "acc:report:".$user['id']) ];
        }
    }
    tg_send_html($chat_id, "<b>گزارش پرسنل</b> — یک نفر را انتخاب کنید:", $kb ?: [[kb_btn("موردی نیست","acc:menu")]]);
}


if (!function_exists('acc_handle_extras')) {
function acc_handle_extras(string $data, int $chat_id): bool {
    if ($data==='acc:assign') {
        tg_send_html($chat_id, "برای تست، مشتری 1001 به DM پیش‌فرض منتصب می‌شود.", [[kb_btn("انجام بده ✅", "acc:assign:1001")]]);
        return true;
    }
    if (strpos($data,'acc:assign:')===0) {
        $cust = (int)substr($data, strlen('acc:assign:'));
        acc_customer_assign_dm($chat_id, $cust, DM_DEFAULT_ID);
        return true;
    }
    if ($data==='acc:store' || $data==='acc:store:list') { acc_store_list($chat_id); return true; }
    if (strpos($data,'acc:store:item:')===0) { acc_store_item($chat_id,(int)substr($data,strlen('acc:store:item:'))); return true; }
    if ($data==='acc:store:add') { acc_store_add($chat_id); return true; }
    if (strpos($data,'acc:store:toggle:')===0) { acc_store_toggle($chat_id,(int)substr($data,strlen('acc:store:toggle:'))); return true; }
    if (strpos($data,'acc:store:edit:')===0) { $p=explode(':',$data); acc_store_begin_edit($chat_id,(int)$p[4],(string)$p[3]); return true; }

    if ($data==='acc:emp_reports') { acc_emp_reports($chat_id); return true; }
    if (strpos($data,'acc:report:')===0) {
        $id = (int)substr($data, strlen('acc:report:'));
        $kb = [
            [ kb_btn("امروز", "acc:reportp:day:".$id), kb_btn("این هفته", "acc:reportp:week:".$id), kb_btn("این ماه", "acc:reportp:month:".$id) ],
            [ kb_btn("↩️ بازگشت", "acc:emp_reports") ]
        ];
        tg_send_html($chat_id, "بازهٔ گزارش را انتخاب کنید:", $kb);
        return true;
    }
    if (strpos($data,'acc:reportp:')===0) {
        $parts = explode(':', $data);
        $period = $parts[2] ?? 'week';
        $id = (int)($parts[3] ?? 0);
        $txt = vm_report_employee_text($id, $period);
        tg_send_html($chat_id, $txt, [[kb_btn("↩️ بازگشت", "acc:report:".$id)]]);
        return true;
    }
    return false;
}
}

require_once __DIR__ . '/../functions/invoices.php';
if (!function_exists('acc_invoices_menu')) {
function acc_invoices_menu(int $chat_id): void {
    $data = invoices_all();
    $items = $data['items'] ?? [];
    if (!$items) {
        tg_send_html($chat_id, "هیچ فاکتوری ثبت نشده است.", [[kb_btn("↩️ بازگشت","acc:menu")]]);
        return;
    }
    $kb = [];
    $i = 1;
    foreach ($items as $inv) {
        $title = "#".$i." — مشتری: ".($inv['customer_name'] ?? '-')." — مبلغ: ".number_format((int)($inv['amount'] ?? 0))." تومان";
        $kb[] = [ kb_btn($title, "acc:invoice:view:".$i) ];
        $i++;
    }
    $kb[] = [ kb_btn("↩️ بازگشت","acc:menu") ];
    tg_send_html($chat_id, "<b>فاکتورها</b>", $kb);
}}

require_once __DIR__ . '/../functions/contracts.php';
if (!function_exists('acc_contracts_menu')) {
function acc_contracts_menu(int $chat_id): void {
    $data = contracts_all();
    $items = $data['items'] ?? [];
    if (!$items) {
        tg_send_html($chat_id, "هیچ قرارداد فعالی ثبت نشده است.", [[kb_btn("↩️ بازگشت","acc:menu")]]);
        return;
    }
    $kb = [];
    $i = 1;
    foreach ($items as $c) {
        $title = "#".$i." — مشتری: ".($c["customer_name"] ?? "-")." — سرویس: ".($c["service"] ?? "-");
        $kb[] = [ kb_btn($title, "acc:contract:view:".$i) ];
        $i++;
    }
    $kb[] = [ kb_btn("↩️ بازگشت","acc:menu") ];
    tg_send_html($chat_id, "<b>قراردادها</b>", $kb);
}}
