<?php
// accounting_ceo_view.php (v897, namespaced ceo:acc:*)
if (!function_exists('acc_ceo_menu')) {
  function acc_ceo_menu($chat_id){
    $rows=[
      [ ['text'=>'🧾 فاکتورها','callback_data'=>'ceo:acc:invoices'], ['text'=>'📄 قراردادها','callback_data'=>'ceo:acc:contracts'] ],
      [ ['text'=>'👥 مشتریان','callback_data'=>'ceo:acc:customers'], ['text'=>'🛒 فروشگاه','callback_data'=>'ceo:acc:store'] ],
      [ ['text'=>'🪪 درخواست‌های نقش','callback_data'=>'ceo:acc:req_center'], ['text'=>'📈 گزارش‌ها','callback_data'=>'ceo:acc:reports'] ],
      [ ['text'=>'🔙 بازگشت','callback_data'=>'ceo:menu'] ]
    ];
    if(function_exists('tg_send_html')) tg_send_html($chat_id,'<b>حسابداری (نمای مدیرعامل)</b>', ['inline_keyboard'=>$rows]);
  }
}
if (!function_exists('acc_ceo_handle')) {
  function acc_ceo_handle($data,$chat_id){
    if ($data==='ceo:acc:menu'){ acc_ceo_menu($chat_id); return; }
    if ($data==='ceo:acc:invoices'){ acc_ceo_view_invoices($chat_id); return; }
    if ($data==='ceo:acc:contracts'){ acc_ceo_view_contracts($chat_id); return; }
    if ($data==='ceo:acc:customers'){ acc_ceo_view_customers($chat_id); return; }
    if ($data==='ceo:acc:store'){ acc_ceo_view_store($chat_id); return; }
    if ($data==='ceo:acc:req_center'){ @require_once __DIR__.'/acc_requests.php'; if(function_exists('acc_req_center')) acc_req_center($chat_id); return; }
    if ($data==='ceo:acc:reports'){ acc_ceo_view_reports($chat_id); return; }
    if (strpos($data,'ceo:acc:invoice:')===0){ if(function_exists('tg_send_html')) tg_send_html($chat_id,'جزئیات فاکتور (نمونه)'); return; }
    if (strpos($data,'ceo:acc:contract:')===0){ if(function_exists('tg_send_html')) tg_send_html($chat_id,'جزئیات قرارداد (نمونه)'); return; }
    if (strpos($data,'ceo:acc:customer:')===0){ if(function_exists('tg_send_html')) tg_send_html($chat_id,'جزئیات مشتری (نمونه)'); return; }
    if(function_exists('tg_send_html')) tg_send_html($chat_id,'دستور ناشناخته در حسابداری (مدیرعامل).');
  }
}
if (!function_exists('acc_ceo_view_invoices')) {
  function acc_ceo_view_invoices($chat_id){
    $rows=[[ ['text'=>'#INV-1001','callback_data'=>'ceo:acc:invoice:1001'], ['text'=>'#INV-1002','callback_data'=>'ceo:acc:invoice:1002'] ],
           [ ['text'=>'🔙 بازگشت','callback_data'=>'ceo:acc:menu'] ]];
    if(function_exists('tg_send_html')) tg_send_html($chat_id,'<b>فاکتورها</b>',['inline_keyboard'=>$rows]);
  }
}
if (!function_exists('acc_ceo_view_contracts')) {
  function acc_ceo_view_contracts($chat_id){
    $rows=[[ ['text'=>'قرارداد A','callback_data'=>'ceo:acc:contract:A'], ['text'=>'قرارداد B','callback_data'=>'ceo:acc:contract:B'] ],
           [ ['text'=>'🔙 بازگشت','callback_data'=>'ceo:acc:menu'] ]];
    if(function_exists('tg_send_html')) tg_send_html($chat_id,'<b>قراردادها</b>',['inline_keyboard'=>$rows]);
  }
}
if (!function_exists('acc_ceo_view_customers')) {
  function acc_ceo_view_customers($chat_id){
    $rows=[[ ['text'=>'مشتری 894457439','callback_data'=>'ceo:acc:customer:894457439'] ],
           [ ['text'=>'🔙 بازگشت','callback_data'=>'ceo:acc:menu'] ]];
    if(function_exists('tg_send_html')) tg_send_html($chat_id,'<b>مشتریان</b>',['inline_keyboard'=>$rows]);
  }
}
if (!function_exists('acc_ceo_view_store')) {
  function acc_ceo_view_store($chat_id){
    $rows=[[ ['text'=>'خدمات: ادمین اینستاگرام','callback_data'=>'ceo:acc:store:item:ig_admin'] ],
           [ ['text'=>'خدمات: طراحی سایت','callback_data'=>'ceo:acc:store:item:web'] ],
           [ ['text'=>'🔙 بازگشت','callback_data'=>'ceo:acc:menu'] ]];
    if(function_exists('tg_send_html')) tg_send_html($chat_id,'<b>فروشگاه</b>',['inline_keyboard'=>$rows]);
  }
}
if (!function_exists('acc_ceo_view_reports')) {
  function acc_ceo_view_reports($chat_id){
    $rows=[[ ['text'=>'گزارش هفتگی','callback_data'=>'ceo:acc:report:week'] ],
           [ ['text'=>'گزارش ماهانه','callback_data'=>'ceo:acc:report:month'] ],
           [ ['text'=>'🔙 بازگشت','callback_data'=>'ceo:acc:menu'] ]];
    if(function_exists('tg_send_html')) tg_send_html($chat_id,'<b>گزارش‌ها</b>',['inline_keyboard'=>$rows]);
  }
}
