<?php
// handlers/dm_ext.php — vm2 Department Manager extended logic
if (!function_exists('vm2_dm_path')) {
  function vm2_dm_path($f){ $p=__DIR__.'/../storage/'.$f; @mkdir(dirname($p),0777,true); return $p; }
  function vm2_dm_read($f){ $p=vm2_dm_path($f); if(!is_file($p)) return []; $d=@json_decode(@file_get_contents($p),true); return is_array($d)?$d:[]; }
  function vm2_dm_write($f,$d){ $p=vm2_dm_path($f); @file_put_contents($p,json_encode($d,JSON_UNESCAPED_UNICODE|JSON_PRETTY_PRINT)); }
}
if (!function_exists('vm2_dm_menu')) {
  function vm2_dm_menu($chat_id){
    $rows=[
      [ ['text'=>'👥 تشکیل تیم مشتری','callback_data'=>'vm2:dm:team'], ['text'=>'🎬 آفیش جدید','callback_data'=>'vm2:dm:offish:new'] ],
      [ ['text'=>'🗓 آفیش‌های این ماه','callback_data'=>'vm2:dm:offish:month'], ['text'=>'📅 تقویم محتوایی','callback_data'=>'vm2:dm:calendar'] ],
      [ ['text'=>'🚨 جریمه','callback_data'=>'vm2:dm:pen'] ],
      [ ['text'=>'🔙 بازگشت','callback_data'=>'ceo:menu'] ]
    ];
    tg_send_html($chat_id,'<b>پنل مدیر دپارتمان (پیشرفته)</b>',['inline_keyboard'=>$rows]);
  }
}
if (!function_exists('vm2_dm_handle')) {
  function vm2_dm_handle($data,$chat_id){
    if ($data==='vm2:dm:menu'){ vm2_dm_menu($chat_id); return; }
    if ($data==='vm2:dm:team'){ tg_send_html($chat_id,'فرم تشکیل تیم باز شد (نمونه).'); return; }
    if ($data==='vm2:dm:offish:new'){ vm2_offish_new($chat_id); return; }
    if ($data==='vm2:dm:offish:month'){ vm2_offish_list_month($chat_id); return; }
    if (strpos($data,'vm2:offish:approve:')===0){ $id=substr($data,strlen('vm2:offish:approve:')); vm2_offish_approve($chat_id,$id,true); return; }
    if (strpos($data,'vm2:offish:reject:')===0){ $id=substr($data,strlen('vm2:offish:reject:')); vm2_offish_approve($chat_id,$id,false); return; }
  }
}
if (!function_exists('vm2_offish_new')) {
  function vm2_offish_new($chat_id){
    $off=vm2_dm_read('offish.json');
    $id='OF-'.(1000+count($off)+1);
    // minimal sample entry; in real flow, pick customer and date/time/location via stepper.
    $off[$id]=[
      'id'=>$id,'customer_id'=>'CUST-1','customer_name'=>'نمونه','page_id'=>'@sample',
      'addr'=>'کرج، ...','loc'=>'35.84, 50.98','date'=>date('Y-m-d', time()+86400),'time'=>'10:00',
      'status'=>'pending','created_at'=>time(),'month_key'=>date('Y-m')
    ];
    vm2_dm_write('offish.json',$off);
    $kb=[
      [ ['text'=>'✅ تایید بلاگر/تصویربردار','callback_data'=>'vm2:offish:approve:'.$id], ['text'=>'⛔️ رد','callback_data'=>'vm2:offish:reject:'.$id] ],
      [ ['text'=>'🔙 بازگشت','callback_data'=>'vm2:dm:menu'] ]
    ];
    tg_send_html($chat_id,'آفیش '.$id.' ثبت شد و به بلاگر/تصویربردار ارسال گردید.',['inline_keyboard'=>$kb]);
  }
}
if (!function_exists('vm2_offish_list_month')) {
  function vm2_offish_list_month($chat_id){
    $off=vm2_dm_read('offish.json'); $mk=date('Y-m'); $rows=[];
    foreach($off as $id=>$o){ if(($o['month_key']??'')===$mk){ $rows[]=[ ['text'=>$id.' • '.$o['date'].' '.$o['time'].' • '.$o['status'],'callback_data'=>'vm2:offish:view:'.$id] ]; } }
    if(!$rows) $rows=[[ ['text'=>'موردی نیست','callback_data'=>'vm2:dm:menu'] ]];
    $rows[]=[ ['text'=>'🔙 بازگشت','callback_data'=>'vm2:dm:menu'] ];
    tg_send_html($chat_id,'آفیش‌های این ماه:',['inline_keyboard'=>$rows]);
  }
}
if (!function_exists('vm2_offish_approve')) {
  function vm2_offish_approve($chat_id,$id,$ok){
    $off=vm2_dm_read('offish.json'); if(!isset($off[$id])){ tg_send_html($chat_id,'آفیش یافت نشد.'); return; }
    $off[$id]['status']=$ok?'approved':'rejected'; vm2_dm_write('offish.json',$off);
    tg_send_html($chat_id,'وضعیت آفیش '.$id.' → '.($ok?'تایید شد':'رد شد').'.',['inline_keyboard'=>[[['text'=>'🔙 بازگشت','callback_data'=>'vm2:dm:offish:month']]]]);
  }
}
