<?php
// handlers/finance.php — vm2 invoices with prepayment, remaining, due date & late fee 150k/day
if (!function_exists('vm2_fin_path')) {
  function vm2_fin_path(){ return __DIR__.'/../storage/invoices.json'; }
  function vm2_fin_read(){ $f=vm2_fin_path(); if(!is_file($f)) return []; $d=@json_decode(@file_get_contents($f),true); return is_array($d)?$d:[]; }
  function vm2_fin_write($d){ @mkdir(dirname(vm2_fin_path()),0777,true); @file_put_contents(vm2_fin_path(),json_encode($d,JSON_UNESCAPED_UNICODE|JSON_PRETTY_PRINT)); }
  function vm2_fin_new($customer,$total,$prepaid,$due_ts){
    $inv=vm2_fin_read(); $id='INV-'.(1000+count($inv)+1);
    $inv[$id]=[ 'id'=>$id,'customer'=>$customer,'total'=>$total,'prepaid'=>$prepaid,'balance'=>$total-$prepaid,'due_at'=>$due_ts,'late_fee_per_day'=>150000,'late_days'=>0,'created_at'=>time(),'status'=>'prepaid' ];
    vm2_fin_write($inv); return $inv[$id];
  }
  function vm2_fin_apply_late_fees(){
    $inv=vm2_fin_read(); $now=time(); $changed=false;
    foreach($inv as &$i){
      if($i['balance']>0 && $now > $i['due_at']){
        $days = (int) floor( ($now - $i['due_at']) / 86400 );
        if ($days > $i['late_days']){
          $diff = $days - $i['late_days'];
          $i['late_days'] = $days;
          $i['balance'] += $diff * ($i['late_fee_per_day'] ?? 150000);
          $changed=true;
        }
      }
    }
    if($changed) vm2_fin_write($inv);
  }
}
