<?php
// handlers/penalties.php — vm2 penalties create/format/apply
if (!function_exists('vm2_pen_path')) {
  function vm2_pen_path(){ return __DIR__.'/../storage/penalties.json'; }
  function vm2_pen_read(){ $f=vm2_pen_path(); if(!is_file($f)) return []; $d=@json_decode(@file_get_contents($f),true); return is_array($d)?$d:[]; }
  function vm2_pen_write($d){ @mkdir(dirname(vm2_pen_path()),0777,true); @file_put_contents(vm2_pen_path(),json_encode($d,JSON_UNESCAPED_UNICODE|JSON_PRETTY_PRINT)); }
  function vm2_pen_general_amount(){ return 250000; } // 250k
  function vm2_pen_make_text($date,$person,$reason,$amount){
    return "#جریمه\n🔴تاریخ جریمه: ".$date."\n🔴نام پرسنل : ".$person."\n🔴دلیل جریمه : ".$reason."\n🔴مبلغ جریمه : ".number_format($amount)." تومان\nبنابر دستور مدیریت و حسابداری کاملا لازم الاجرا و عملی خواهد بود .";
  }
  function vm2_pen_add($person,$reason,$amount=null,$auto=false){
    $list=vm2_pen_read();
    $rec=[ 'id'=>'P'.time(), 'person'=>$person, 'reason'=>$reason, 'amount'=>$amount??vm2_pen_general_amount(), 'auto'=>$auto, 'at'=>time() ];
    $list[]=$rec; vm2_pen_write($list);
    return $rec;
  }
}
