<?php
// cron/deadlines.php — process offish deadlines and 24h/penalties logic (skeleton applying general penalty on missed tasks)
require_once __DIR__.'/../bot/functions/jdate.php';
require_once __DIR__.'/../bot/handlers/penalties.php';
$taskf = __DIR__.'/../bot/storage/tasks.json';
$tasks = is_file($taskf)? json_decode(file_get_contents($taskf), true): [];
$now = time();
$changed=false;
foreach($tasks as &$t){
  if(($t['status']??'open')==='open' && $now > ($t['due_at']??0)){
    // auto penalty
    $rec = vm2_pen_add($t['uid'] ?? 'unknown', 'عدم انجام وظیفه: '.$t['title'], null, true);
    $t['status']='overdue';
    $t['penalty_id']=$rec['id'];
    $changed=true;
  }
}
if($changed) file_put_contents($taskf, json_encode($tasks, JSON_UNESCAPED_UNICODE|JSON_PRETTY_PRINT));
echo "deadlines processed\n";
