<?php
declare(strict_types=1);

require_once __DIR__ . '/../core/utils.php';
require_once __DIR__ . '/../core/storage.php';
require_once __DIR__ . '/../core/telegram.php';
require_once __DIR__ . '/../core/scheduler.php';
require_once __DIR__ . '/../config/env.php';
require_once __DIR__ . '/tasks.php';

if (!defined('CUSTOMERS_FILE')) define('CUSTOMERS_FILE', VM_STORAGE . '/customers.json');
if (!defined('EMPLOYEES_FILE')) define('EMPLOYEES_FILE', VM_STORAGE . '/employees.json');
if (!defined('SHOOTS_FILE'))    define('SHOOTS_FILE',    VM_STORAGE . '/shoots.json');
if (!defined('SCENARIOS_FILE')) define('SCENARIOS_FILE', VM_STORAGE . '/scenarios.json');
if (!defined('EDITS_FILE'))     define('EDITS_FILE',     VM_STORAGE . '/edits.json');

// تیم مشتری
function dept_assign_team(int $customer_chat_id, array $team): bool {
    $custs = storage_load(CUSTOMERS_FILE, []);
    foreach ($custs as &$c) {
        if ((int)$c['chat_id'] === $customer_chat_id) {
            $c['team'] = array_merge(['manager'=>0,'scenarist'=>0,'blogger'=>0,'videographer'=>0,'editor'=>0,'admin'=>0], $team);
            $c['team_ts']=time(); $ok=storage_save(CUSTOMERS_FILE,$custs);
            if($ok && !empty($c['team']['manager'])){
                $mgr=(int)$c['team']['manager']; $deadline=time()+OFFISH_FIRST_DEADLINE_DAYS*86400;
                task_create($mgr, "ثبت اولین آفیش مشتری ".tg_escape($c['brand']??'بدون‌نام'), "حداکثر تا ۷ روز آینده باید آفیش اول ثبت شود.", $deadline, 'dept_manager', $mgr);
            }
            return $ok;
        }
    }
    return false;
}
function dept_get_team(int $customer_chat_id): array {
    $custs = storage_load(CUSTOMERS_FILE, []);
    foreach ($custs as $c) if ((int)$c['chat_id']===$customer_chat_id) return $c['team']??[];
    return [];
}

// آفیش
function offish_month_quota_used(int $customer_chat_id, int $monthTs=null): int {
    $monthTs = $monthTs ?? time(); $y=(int)date('Y',$monthTs); $m=(int)date('m',$monthTs);
    $start=mktime(0,0,0,$m,1,$y); $end=mktime(23,59,59,$m,cal_days_in_month(CAL_GREGORIAN,$m,$y),$y);
    $all=storage_load(SHOOTS_FILE,[]); $n=0; foreach($all as $s){ if((int)$s['customer_chat_id']!==$customer_chat_id) continue; $dt=(int)($s['date_ts']??0); if($dt>=$start && $dt<=$end)$n++; } return $n;
}
function offish_create(int $customer_chat_id, int $manager_id, string $date_jalali, string $hour, string $address, string $location, string $ig_handle, bool $forceExtra=false): int {
    $used=offish_month_quota_used($customer_chat_id); if($used>=OFFISH_QUOTA && !$forceExtra){ tg_send_html($manager_id,"⛔️ سهمیه ماهانه تکمیل است. برای آفیش اضافه با حسابداری هماهنگ کن."); return 0; }
    $date_ts = jstrtotime($date_jalali." ".$hour.":00"); if(!$date_ts){ tg_send_html($manager_id,'⛔️ تاریخ/ساعت نامعتبر.'); return 0; }
    $team=dept_get_team($customer_chat_id); $blogger=(int)($team['blogger']??0); $video=(int)($team['videographer']??0);
    $all=storage_load(SHOOTS_FILE,[]); $id=(count($all)? max(array_column($all,'id')):0)+1;
    $rec=['id'=>$id,'customer_chat_id'=>$customer_chat_id,'manager_id'=>$manager_id,'blogger_id'=>$blogger,'videographer_id'=>$video,'date_ts'=>$date_ts,'hour'=>$hour,'address'=>$address,'location'=>$location,'ig_handle'=>$ig_handle,'status'=>'pending','blogger_accept'=>null,'videographer_accept'=>null];
    $all[]=$rec; storage_save(SHOOTS_FILE,$all);
    $info="👤 مشتری: ".tg_escape($ig_handle)."\n📍 آدرس: ".tg_escape($address)."\n🗺️ لوکیشن: ".tg_escape($location)."\n🗓️ تاریخ: <b>".jdate('Y/m/d',$date_ts)."</b>\n⏰ ساعت: <b>{$hour}</b>";
    if($blogger){ tg_send_kb_html($blogger,"🎬 <b>آفیش جدید</b>\n{$info}\nآیا تایید می‌کنید؟", yesno_btns("offish:accept:blogger:{$id}", "offish:reject:blogger:{$id}")); }
    if($video){   tg_send_kb_html($video,  "🎥 <b>آفیش جدید</b>\n{$info}\nآیا تایید می‌کنید؟", yesno_btns("offish:accept:video:{$id}",   "offish:reject:video:{$id}")); }
    tg_send_html($customer_chat_id, "📢 برنامه آفیش شما تنظیم شد:\n{$info}");
    if ($sc=(int)($team['scenarist']??0)) task_for_scenarist($sc, "سناریو برای آفیش #".to_persian_num($id)." ({$ig_handle})", "با مدیر دپارتمان هماهنگ و ظرف ۳۰ ساعت ارسال کن.");
    return $id;
}
function offish_set_accept(int $shoot_id, string $who, bool $ok): bool {
    $all=storage_load(SHOOTS_FILE,[]); foreach($all as &$s){ if((int)$s['id']===$shoot_id){
        if($who==='blogger') $s['blogger_accept']=$ok; elseif($who==='video') $s['videographer_accept']=$ok;
        if($s['blogger_accept']===true && $s['videographer_accept']===true) $s['status']='confirmed';
        return storage_save(SHOOTS_FILE,$all);
    }} return false;
}
function offish_arrival_prompt(int $shoot_id): void {
    $all=storage_load(SHOOTS_FILE,[]); foreach($all as $s){ if((int)$s['id']===$shoot_id){
        $vid=(int)($s['videographer_id']??0); if($vid){
            $kb = yesno_btns("offish:arrived:yes:{$shoot_id}", "offish:arrived:no:{$shoot_id}");
            tg_send_kb_html($vid, "⏳ آیا در آفیش #".to_persian_num($shoot_id)." حاضر شدی؟", $kb);
        } return;
    }}
}
function offish_mark_arrived(int $shoot_id, bool $present): void {
    $all=storage_load(SHOOTS_FILE,[]); foreach($all as &$s){ if((int)$s['id']===$shoot_id){
        $mgr=(int)($s['manager_id']??0); $vid=(int)($s['videographer_id']??0);
        if(!$present){ if($mgr) tg_send_html($mgr,"🚨 تصویربردار هنوز به آفیش #".to_persian_num($shoot_id)." نرسیده."); return; }
        $s['enter_ts']=time(); storage_save(SHOOTS_FILE,$all);
        $ts=time()+OFFISH_FINISH_BTN_DELAY*60;
        sched_enqueue('send_reminder', $ts, [
            'user_id'=>$vid,'chat_id'=>$vid,'title'=>"اتمام آفیش #{$shoot_id}",
            'buttons'=>kb_inline([[ kb_btn('🛑 اتمام آفیش', "offish:finish:{$shoot_id}") ]]),
        ]);
        tg_send_html($vid,"✅ حضور شما ثبت شد. هر زمان کار تموم شد، «🛑 اتمام آفیش» رو بزن.");
        return;
    }}
}
function offish_finish(int $shoot_id): void {
    $all=storage_load(SHOOTS_FILE,[]); foreach($all as &$s){ if((int)$s['id']===$shoot_id){
        $s['exit_ts']=time(); $s['status']='done'; storage_save(SHOOTS_FILE,$all);
        $mgr=(int)($s['manager_id']??0); if($mgr){ $in=isset($s['enter_ts'])? jdate('Y/m/d H:i',(int)$s['enter_ts']):'—'; $out=jdate('Y/m/d H:i',(int)$s['exit_ts']); tg_send_html($mgr,"📋 آفیش #".to_persian_num($shoot_id)." پایان یافت.\n⏱️ ورود: {$in}\n🏁 خروج: {$out}"); }
        return;
    }}
}

// سناریو/تحویل فایل/تقویم (نسخهٔ خلاصه‌تر)
function scenario_register_counts(int $shoot_id, int $scenarist_id, int $posts, int $stories, int $covers): int {
    $all=storage_load(SCENARIOS_FILE,[]); $id=(count($all)? max(array_column($all,'id')):0)+1;
    $all[]=['id'=>$id,'shoot_id'=>$shoot_id,'scenarist_id'=>$scenarist_id,'posts'=>$posts,'stories'=>$stories,'covers'=>$covers,'created_ts'=>time()];
    storage_save(SCENARIOS_FILE,$all); return $id;
}
function video_mark_sent_raw(int $shoot_id, int $videographer_id): void {
    $edits=storage_load(EDITS_FILE,[]); $found=false;
    foreach($edits as &$e){ if((int)$e['shoot_id']===$shoot_id){ $e['raw_sent']=true; $e['raw_sent_ts']=time(); $found=true; break; } }
    if(!$found){ $edits[]=['shoot_id'=>$shoot_id,'raw_sent'=>true,'raw_sent_ts'=>time(),'editor_checked'=>false,'complete'=>false]; }
    storage_save(EDITS_FILE,$edits); tg_send_html($videographer_id,"✅ تایید شد: فایل‌های خام آفیش #".to_persian_num($shoot_id)." ارسال شد.");
    $shoots=storage_load(SHOOTS_FILE,[]); $editor=0; foreach($shoots as $s) if((int)$s['id']===$shoot_id){ $team=dept_get_team((int)$s['customer_chat_id']); $editor=(int)($team['editor']??0); break; }
    if($editor) task_for_editor($editor,"بررسی دریافت فایل‌های آفیش #{$shoot_id}",'check_files','تعداد فایل‌ها را با سناریو تطبیق بده.');
}
function editor_check_completeness(int $shoot_id, string $status): void {
    $edits=storage_load(EDITS_FILE,[]); foreach($edits as &$e){ if((int)$e['shoot_id']===$shoot_id){
        $e['editor_checked']=true; $e['complete']=($status==='ok'); storage_save(EDITS_FILE,$edits);
        if($status!=='ok'){ $shoots=storage_load(SHOOTS_FILE,[]); foreach($shoots as $s) if((int)$s['id']===$shoot_id){ $mgr=(int)($s['manager_id']??0); if($mgr) tg_send_html($mgr,"⚠️ آفیش #".to_persian_num($shoot_id)." ناقص گزارش شد."); break; } }
        else { $shoots=storage_load(SHOOTS_FILE,[]); $editor=0; foreach($shoots as $s) if((int)$s['id']===$shoot_id){ $team=dept_get_team((int)$s['customer_chat_id']); $editor=(int)($team['editor']??0); break; } if($editor) task_for_editor($editor,"ساخت اولین ویدئو برای آفیش #{$shoot_id}",'first_video','نسخه اول را بساز و تحویل ادمین بده.'); }
        return;
    }}
}

// تقویم محتوایی
function content_calendar_set(int $shoot_id, array $postsDays, array $storyDays): bool {
    $all=storage_load(SHOOTS_FILE,[]); foreach($all as &$s){ if((int)$s['id']===$shoot_id){
        $s['content_calendar']=['posts'=>array_values(array_unique(array_map('intval',$postsDays))),'stories'=>array_values(array_unique(array_map('intval',$storyDays)))];
        $ok=storage_save(SHOOTS_FILE,$all);
        $team=dept_get_team((int)$s['customer_chat_id']); $admin=(int)($team['admin']??0);
        if($ok && $admin){
            $base=time(); for($i=1;$i<=7;$i++){ $ts=$base+$i*86400; $w=(int)date('w',$ts); $wfa=($w===6)?0:$w+1;
                if(in_array($wfa,$s['content_calendar']['posts'],true))  task_for_admin_content($admin,"آپلود پست (آفیش #{$shoot_id})",'طبق تقویم محتوایی پست را آپلود کن.',$ts);
                if(in_array($wfa,$s['content_calendar']['stories'],true))task_for_admin_content($admin,"آپلود استوری (آفیش #{$shoot_id})",'طبق تقویم محتوایی استوری را آپلود کن.',$ts);
            }
            tg_send_html($admin,"🗓️ تقویم محتوایی ثبت شد. وظایف روزانه در «وظیفه‌های من» قرار گرفت.");
        }
        return $ok;
    }} return false;
}

// روتر کال‌بک
function dept_handle_callback(int $chat_id, int $user_id, string $data): bool {
    if (preg_match('~^offish:(accept|reject):(blogger|video):(\d+)$~',$data,$m)){
        $ok = $m[1]==='accept'; $who=$m[2]; $sid=(int)$m[3];
        if(offish_set_accept($sid,$who,$ok)){ tg_send_html($chat_id,$ok?'✅ ثبت شد.':'❌ رد شد.'); if(!$ok){ $shoots=storage_load(SHOOTS_FILE,[]); foreach($shoots as $s) if((int)$s['id']===$sid){ $mgr=(int)($s['manager_id']??0); if($mgr) tg_send_html($mgr,"⛔️ یک نفر آفیش #".to_persian_num($sid)." را رد کرد."); break; } }
        } else tg_send_html($chat_id,'⛔️ خطا.');
        return true;
    }
    if (preg_match('~^offish:arrived:(yes|no):(\d+)$~',$data,$m)){ offish_mark_arrived((int)$m[2], $m[1]==='yes'); return true; }
    if (preg_match('~^offish:finish:(\d+)$~',$data,$m)){ offish_finish((int)$m[1]); return true; }
    return false;
}

return true;
