<?php
// lib/Telegram.php (hardcoded API base to avoid config mistakes)
require_once __DIR__.'/Logger.php';
class Telegram {
  private $api;
  function __construct($token, $api_base){
    // Ignore $api_base to avoid misconfig 404s
    $this->api = "https://api.telegram.org/bot".$token."/";
  }
  private function req($method, $params = []){
    $url = $this->api.$method;
    // cURL
    if (function_exists('curl_init')){
      $ch = curl_init($url);
      curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
      curl_setopt($ch, CURLOPT_POST, true);
      curl_setopt($ch, CURLOPT_POSTFIELDS, $params);
      $res = curl_exec($ch);
      if ($res === false){
        $err = curl_error($ch);
        Logger::write('tg_errors.log', ['url'=>$url,'method'=>$method,'curl_error'=>$err]);
        curl_close($ch);
      } else {
        $http = curl_getinfo($ch, CURLINFO_RESPONSE_CODE);
        Logger::write('tg_requests.log', ['url'=>$url,'method'=>$method,'http'=>$http,'response'=>$res]);
        curl_close($ch);
        return json_decode($res, true);
      }
    } else {
      Logger::write('tg_errors.log', ['url'=>$url,'method'=>$method,'curl_error'=>'CURL EXTENSION MISSING']);
    }
    // Fallback streams
    $opts = ['http'=>['method'=>'POST','header'=>"Content-Type: application/x-www-form-urlencoded\r\n",'content'=>http_build_query($params),'timeout'=>15]];
    $ctx = stream_context_create($opts);
    $res = @file_get_contents($url, false, $ctx);
    Logger::write('tg_requests.log', ['url'=>$url,'method'=>$method,'stream_meta'=>isset($http_response_header)?$http_response_header:null,'response'=>$res]);
    return $res ? json_decode($res, true) : null;
  }
  function sendMessage($chat_id,$text,$kb=null,$parse_mode='HTML'){
    $p = ['chat_id'=>$chat_id,'text'=>$text,'parse_mode'=>$parse_mode,'disable_web_page_preview'=>true];
    if ($kb) $p['reply_markup'] = json_encode($kb, JSON_UNESCAPED_UNICODE);
    return $this->req('sendMessage',$p);
  }
  function editMessageText($chat_id,$mid,$text,$kb=null,$parse_mode='HTML'){
    $p = ['chat_id'=>$chat_id,'message_id'=>$mid,'text'=>$text,'parse_mode'=>$parse_mode,'disable_web_page_preview'=>true];
    if ($kb) $p['reply_markup'] = json_encode($kb, JSON_UNESCAPED_UNICODE);
    return $this->req('editMessageText',$p);
  }
  function answerCallback($cbid,$text='',$alert=false){
    return $this->req('answerCallbackQuery', ['callback_query_id'=>$cbid,'text'=>$text,'show_alert'=>$alert]);
  }
}
