<?php
// Minimal FPDF 1.81 (stripped header) - for simple PDF generation
// Source: http://www.fpdf.org/ (embedded for portability)
class FPDF
{
protected $page;protected $n;protected $offsets;protected $buffer;protected $pages;protected $state;protected $compress;protected $k;protected $DefOrientation;protected $CurOrientation;protected $StdPageSizes;protected $DefPageSize;protected $CurPageSize;protected $CurRotation;protected $PageSizes;protected $wPt;protected $hPt;protected $w;protected $h;protected $lMargin;protected $tMargin;protected $rMargin;protected $bMargin;protected $cMargin;protected $x;protected $y;protected $lasth;protected $LineWidth;protected $fontpath;protected $CoreFonts;protected $fonts;protected $FontFiles;protected $encodings;protected $cmaps;protected $FontFamily;protected $FontStyle;protected $underline;protected $CurrentFont;protected $FontSizePt;protected $FontSize;protected $DrawColor;protected $FillColor;protected $TextColor;protected $ColorFlag;protected $WithAlpha;protected $ws;protected $images;protected $PageLinks;protected $links;protected $AutoPageBreak;protected $PageBreakTrigger;protected $InHeader;protected $InFooter;protected $AliasNbPages;protected $ZoomMode;protected $LayoutMode;protected $metadata;
function __construct($orientation='P',$unit='mm',$size='A4'){ $this->_dochecks(); $this->page=0;$this->n=2;$this->buffer='';$this->pages=array();$this->PageSizes=array();$this->state=0;$this->fonts=array();$this->FontFiles=array();$this->encodings=array();$this->cmaps=array();$this->images=array();$this->links=array();$this->InHeader=false;$this->InFooter=false;$this->lasth=0;$this->FontFamily='';$this->FontStyle='';$this->FontSizePt=12;$this->underline=false;$this->DrawColor='0 G';$this->FillColor='0 g';$this->TextColor='0 g';$this->ColorFlag=false;$this->WithAlpha=false;$this->ws=0; if($unit=='pt') $this->k=1; elseif($unit=='mm') $this->k=72/25.4; elseif($unit=='cm') $this->k=72/2.54; elseif($unit=='in') $this->k=72; else $this->Error('Incorrect unit: '.$unit); $this->DefOrientation=$orientation; $this->CurOrientation=$orientation; $this->DefPageSize=$this->_getpagesize($size); $this->CurPageSize=$this->DefPageSize; $this->PageSizes=array(); $this->wPt=$this->DefPageSize[0]; $this->hPt=$this->DefPageSize[1]; $this->w=$this->wPt/$this->k; $this->h=$this->hPt/$this->k; $this->fontpath=__DIR__.'/font/'; $this->SetMargins(10,10); $this->SetAutoPageBreak(true,10); $this->SetDisplayMode('default'); $this->SetCompression(true); $this->CoreFonts=array('courier','helvetica','times','symbol','zapfdingbats'); }
function SetCompression($compress){ $this->compress=$compress; }
function SetMargins($left,$top,$right=null){ $this->lMargin=$left; $this->tMargin=$top; if($right===null) $right=$left; $this->rMargin=$right; }
function SetAutoPageBreak($auto,$margin=0){ $this->AutoPageBreak=$auto; $this->bMargin=$margin; $this->PageBreakTrigger=$this->h-$margin; }
function SetDisplayMode($zoom,$layout='default'){ $this->ZoomMode=$zoom; $this->LayoutMode=$layout; }
function AddPage($orientation=''){ if($this->state==0) $this->Open(); $family=$this->FontFamily; $style=$this->FontStyle.($this->underline?'U':''); $size=$this->FontSizePt; $lw=$this->LineWidth; $dc=$this->DrawColor; $fc=$this->FillColor; $tc=$this->TextColor; $cf=$this->ColorFlag; $this->_beginpage($orientation); $this->_out('2 J'); $this->LineWidth=$lw; $this->_out(sprintf('%.2F w',$lw*$this->k)); if($family) $this->SetFont($family,$style,$size); $this->DrawColor=$dc; if($dc!='0 G') $this->_out($dc); $this->FillColor=$fc; if($fc!='0 g') $this->_out($fc); $this->TextColor=$tc; $this->ColorFlag=$cf; }
function SetFont($family,$style='',$size=0){ $family=strtolower($family); if($family=='arial') $family='helvetica'; $style=strtoupper($style); if(strpos($style,'U')!==false){ $this->underline=true; $style=str_replace('U','',$style); } else $this->underline=false; if($size==0) $size=$this->FontSizePt; $this->FontFamily=$family; $this->FontStyle=$style; $this->FontSizePt=$size; $this->FontSize=$size/$this->k; if(!isset($this->fonts[$family.$style])) $this->AddFont($family,$style); $this->CurrentFont=$this->fonts[$family.$style]; }
function AddFont($family,$style='',$file=''){ $family=strtolower($family); $style=strtoupper($style); $fontkey=$family.$style; if(isset($this->fonts[$fontkey])) return; $this->fonts[$fontkey]=array('i'=>count($this->fonts)+1,'type'=>'core','name'=>ucfirst($family).($style=='B'?' Bold':($style=='I'?' Italic':''))); }
function SetTextColor($r){ $this->TextColor=sprintf('%.3F g',$r/255); $this->ColorFlag=($this->FillColor!=$this->TextColor); }
function SetDrawColor($r){ $this->DrawColor=sprintf('%.3F G',$r/255); }
function SetFillColor($r){ $this->FillColor=sprintf('%.3F g',$r/255); }
function SetLineWidth($width){ $this->LineWidth=$width; $this->_out(sprintf('%.2F w',$width*$this->k)); }
function Cell($w,$h=0,$txt='',$border=0,$ln=0,$align='',$fill=false,$link=''){ $k=$this->k; if($this->y+$h>$this->PageBreakTrigger && !$this->InHeader && !$this->InFooter && $this->AutoPageBreak){ $this->AddPage($this->CurOrientation); } $s=''; if($fill) $s='f'; if($txt!==''){ $s.=' BT /F'.$this->CurrentFont['i'].' '.$this->FontSizePt.' Tf '.($align=='R'?'1 0 0 1 '.sprintf('%.2F %.2F',($this->x+$w-$this->GetStringWidth($txt))*$k,($this->h-$this->y-.5*$h)*$k):'1 0 0 1 '.sprintf('%.2F %.2F',$this->x*$k,($this->h-$this->y-.5*$h)*$k)).' Tm ('.$this->_escape($txt).') Tj ET'; }
 else $s.=' '; if($s) $this->_out($s); $this->x+=$w; if($ln>0){ $this->y+=$h; $this->x=$this->lMargin; } }
function Ln($h=null){ $this->x=$this->lMargin; if($h===null) $this->y+=$this->lasth; else $this->y+=$h; }
function MultiCell($w,$h,$txt,$border=0,$align='J',$fill=false){ foreach(explode("\n",$txt) as $line){ $this->Cell($w,$h,$line,0,1,$align,$fill); } }
function Output($dest='F',$name='doc.pdf'){ $this->_enddoc(); if($dest=='F') file_put_contents($name,$this->buffer); else { header('Content-Type: application/pdf'); header('Content-Length: '.strlen($this->buffer)); header('Content-Disposition: inline; filename="'.$name.'"'); echo $this->buffer; } }
protected function _dochecks(){ if(1){return;} }
protected function _getpagesize($size){ if(is_string($size)){ $size=strtolower($size); $a=$size=='a4'?[595.28,841.89]:[595.28,841.89]; return $a; } else return $size; }
protected function _beginpage($orientation){ $this->page++; $this->pages[$this->page]=''; $this->state=2; $this->x=$this->lMargin; $this->y=$this->tMargin; $this->lasth=0; }
protected function _out($s){ if($this->state==2) $this->pages[$this->page].=$s."\n"; else $this->buffer.=$s."\n"; }
protected function _escape($s){ $s=str_replace('\\','\\\\',$s); $s=str_replace('(','\\(',$s); $s=str_replace(')','\\)',$s); $s=str_replace("\r",'',$s); return $s; }
protected function _enddoc(){ $this->_endpage(); $this->_putpages(); $this->_putresources(); $this->_putinfo(); $this->_putcatalog(); $o=strlen($this->buffer); $this->_put('xref'); $this->_put('0 '.$this->n); $this->_put('0000000000 65535 f '); for($i=1;$i<$this->n;$i++) $this->_put(sprintf('%010d 00000 n ',$this->offsets[$i])); $this->_put('trailer'); $this->_put('<</Size '.$this->n.'/Root 1 0 R/Info 2 0 R>>'); $this->_put('startxref'); $this->_put($o); $this->_put('%%EOF'); }
protected function _endpage(){ if($this->state!=2) return; $this->state=1; }
protected function _put($s){ $this->buffer.=$s."\n"; }
protected function _putpages(){ $nb=$this->page; if(!isset($this->PageSizes)) $this->PageSizes=array(); for($n=1;$n<=$nb;$n++) $this->PageSizes[$n]=[$this->wPt,$this->hPt]; $filter=($this->compress)?'/Filter /FlateDecode ':''; for($n=1;$n<=$nb;$n++){ $this->_newobj(); $this->_put('<</Type /Page/Parent 1 0 R/Resources 2 0 R/MediaBox [0 0 '.$this->wPt.' '.$this->hPt.']>>'); $this->_put('endobj'); $this->_newobj(); $p=($this->pages[$n]); $this->_put('<</Length '.strlen($p).'>>'); $this->_put('stream'); $this->_put($p); $this->_put('endstream'); $this->_put('endobj'); } $this->_newobj(); $kids=''; for($n=1;$n<=$nb;$n++) $kids.=(3*$n-1).' 0 R '; $this->_put('<</Type /Pages/Count '.$nb.'/Kids ['.$kids.']>>'); $this->_put('endobj'); }
protected function _newobj(){ $this->offsets[$this->n]=strlen($this->buffer); $this->_put($this->n.' 0 obj'); $this->n++; }
protected function _putresources(){ $this->_newobj(); $this->_put('<</ProcSet [/PDF /Text]>>'); $this->_put('endobj'); }
protected function _putinfo(){ $this->_newobj(); $this->_put('<</Producer (FPDF)>>'); $this->_put('endobj'); }
protected function _putcatalog(){ $this->_newobj(); $this->_put('<</Type /Catalog/Pages '.($this->n-2).' 0 R>>'); $this->_put('endobj'); }
}
