<?php
declare(strict_types=1);
if(function_exists('vm_get_tz')) @date_default_timezone_set(vm_get_tz());
require_once __DIR__.'/functions/reports.php';
if(defined('TIMEZONE')&&TIMEZONE) @date_default_timezone_set(TIMEZONE);

declare(strict_types=1);
require_once __DIR__ . '/config.php';
require_once __DIR__ . '/functions/utils.php';
require_once __DIR__ . '/functions/storage.php';
require_once __DIR__ . '/functions/telegram.php';
require_once __DIR__ . '/functions/photographer_upload_review.php';
if(defined('TIMEZONE')&&TIMEZONE) @date_default_timezone_set(TIMEZONE);
storage_boot();
log_line('[CRON] run');

$items = raw_list('editing');
foreach ($items as $it) {
    $deadline = (int)($it['deadline_ts'] ?? 0);
    if ($deadline && time() > $deadline) {
        tg_send_html(DM_DEFAULT_ID, "⏰ ددلاین ادیت برای فایل #".$it['id']." گذشته است.");
        tg_send_html(CEO_ID, "⏰ ددلاین ادیت برای فایل #".$it['id']." گذشته است.");
    }
}
echo "cron ok";


require_once __DIR__ . '/functions/tasks.php';
require_once __DIR__ . '/functions/penalties.php';
require_once __DIR__ . '/functions/storage.php';
require_once __DIR__ . '/functions/utils.php';

// Task reminders (5h & 1h before)
$now = time();
$t = tasks_all();
foreach (($t['items'] ?? []) as $task) {
    if (($task['status'] ?? '') !== 'pending') continue;
    $due = (int)($task['due_ts'] ?? 0);
    if (!$due) continue;
    $diff = $due - $now;
    if ($diff <= 3600 && $diff > 0) {
        tg_send_html((int)$task['user_id'], "⏰ ۱ ساعت تا پایان وظیفه #{$task['id']} مانده.\n".$task['title']."\n", [[kb_btn("تمام شد ✅","emp:task:done:".$task['id'])]]);
    } elseif ($diff <= 5*3600 and $diff > 3600) {
        tg_send_html((int)$task['user_id'], "⏰ ۵ ساعت تا پایان وظیفه #{$task['id']} مانده.\n".$task['title']."\n", [[kb_btn("تمام شد ✅","emp:task:done:".$task['id'])]]);
    } elseif ($diff <= 0) {
        // Overdue -> auto public penalty
        task_set_status((int)$task['id'],'overdue');
        pen_add((int)$task['user_id'], 250000, "تاخیر در انجام وظیفه #".$task['id']);
    }
}

// Late fee on invoices + reminders to customers at 10:00, 14:00, 21:00
$inv = invoices_all();
$hm = date('H:i');
foreach ($inv as &$it) {
    $bal = (int)($it['balance'] ?? 0);
    if ($bal > 0) {
        $due = strtotime($it['due_date'] ?? ''); if ($due && $now > $due) {
            // add daily late fee once per day after midnight
            $last = (int)($it['late_last_ts'] ?? 0);
            $mid = strtotime(date('Y-m-d 00:05'));
            if ($last < $mid) {
                $bal += LATE_FEE_PER_DAY;
                $it['balance'] = $bal;
                $it['late_last_ts'] = $now;
            }
            // reminders at fixed times
            if (in_array($hm, REMIND_TIMES)) {
                $cid = (int)($it['customer_chat_id'] ?? 0);
                if ($cid) {
                    $msg = "یادآوری مانده فاکتور: ".number_format($bal)." تومان.\nلطفاً پرداخت و رسید را ارسال کنید.";
                    tg_send_html($cid, $msg);
                }
            }
        }
    }
}
invoices_save($inv);


require_once __DIR__ . '/functions/offish.php';

// Auto-delete reminders after N minutes
$M = messages_all(); $keep=[];
foreach (($M['items']??[]) as $m) {
    $age = time() - (int)($m['ts'] ?? 0);
    if ($age > AUTO_DELETE_REMINDERS_MIN*60) {
        /* try delete */ tg_api('deleteMessage', ['chat_id'=>(int)$m['chat_id'],'message_id'=>(int)$m['message_id']]);
    } else {
        $keep[] = $m;
    }
}
messages_save(['items'=>$keep]);

// Arrival prompts at offish time
$off = offish_all();
foreach (($off['items']??[]) as $it) {
    if (($it['status']??'')!=='scheduled') continue;
    $dt = (int)($it['date_ts']??0); if (!$dt) continue;
    if (abs(time()-$dt) < 5*60 && empty($it['arrival_prompted'])) {
        offish_arrival_prompt((int)$it['id']);
        // mark prompted
        $it['arrival_prompted'] = 1;
    }
}
offish_save($off);

// CRON HEALTH

vm_reports_auto();
