<?php
declare(strict_types=1);
require_once __DIR__ . '/../functions/telegram.php';
require_once __DIR__ . '/../functions/utils.php';
require_once __DIR__ . '/../functions/storage.php';
function cust_menu(int $chat_id): void {
    $rows = [
        [ kb_btn(icon('contract')." قرارداد من", 'cust:contracts'), kb_btn(icon('invoice')." فاکتورهای من", 'cust:invoices') ],
        [ kb_btn('🛍️ فروشگاه', 'cust:store'), kb_btn('سرویس‌های من', 'cust:services') ],
        [ kb_btn(icon('back')." خانه", 'back:home') ],
    ];
    tg_send_html($chat_id, friendly_greeting()."\n\n".icon('customer')." <b>پنل مشتری</b>", $rows);
}
function cust_handle(string $data, int $chat_id): void {
    if ($data === 'cust:menu') { cust_menu($chat_id); return; }
    if ($data === 'cust:contracts') {
        $items = contracts_all();
        $my = array_values(array_filter($items, fn($x)=> (int)($x['customer_chat_id']??0) === $chat_id));
        $txt = "<b>قراردادهای شما:</b>\n".($my? json_encode($my, JSON_UNESCAPED_UNICODE|JSON_PRETTY_PRINT):"چیزی ثبت نشده");
        tg_send_html($chat_id, friendly_greeting()."\n\n".$txt);
    } elseif ($data === 'cust:invoices') {
        $items = invoices_all();
        $my = array_values(array_filter($items, fn($x)=> (int)($x['customer_chat_id']??0) === $chat_id));
        $txt = "<b>فاکتورهای شما:</b>\n".($my? json_encode($my, JSON_UNESCAPED_UNICODE|JSON_PRETTY_PRINT):"خالی");
        tg_send_html($chat_id, friendly_greeting()."\n\n".$txt);
    }
}


require_once __DIR__ . '/../functions/store.php';

function cust_store(int $chat_id): void {
    store_seed_if_empty();
    $s = store_all();
    $txt = "🛍️ <b>فروشگاه ویژن مدیا</b>\n";
    $txt .= "نام حقوقی: ".COMPANY_LEGAL." | ثبت: ".COMPANY_REG_NO."\nشناسه ملی: ".COMPANY_NATIONAL_ID."\nنشانی: ".COMPANY_ADDRESS."\nوبسایت: ".COMPANY_WEBSITE."\n";
    foreach ($s['services'] as $srv) {
        $txt .= "\n— <b>{$srv['name']}</b> — قیمت: ".number_format($srv['price'])." تومان\n".$srv['desc']."\n";
    }
    $kb = [[ kb_btn("درخواست خرید کارت‌به‌کارت", "cust:buy") ], [ kb_btn(icon('back')." بازگشت", 'cust:menu') ]];
    tg_send_html($chat_id, $txt, $kb);
}
function cust_services(int $chat_id): void {
    tg_send_html($chat_id, "📦 سرویس‌های فعال شما (نسخهٔ نمونه).");
}
function cust_handle_plus(string $data, int $chat_id): bool {
    if ($data==='cust:store') { cust_store_list($chat_id); return true; }
    if (strpos($data,'cust:store:item:')===0) { $id=(int)substr($data, strlen('cust:store:item:')); cust_store_item($chat_id,$id); return true; }
    if ($data==='cust:store') { cust_store($chat_id); return true; }
    if ($data==='cust:services') { cust_services($chat_id); return true; }
    if ($data==='cust:buy') { tg_send_html($chat_id, "برای خرید کارت‌به‌کارت، رسید را ارسال کنید تا حسابداری تأیید کند."); return true; }
    return false;
}


require_once __DIR__ . '/../functions/store.php';

function cust_store_list(int $chat_id): void {
    store_seed_if_empty();
    $items = array_values(array_filter(store_list(), fn($x)=> !empty($x['active'])));
    if (!$items) { tg_send_html($chat_id, "فعلاً خدمتی موجود نیست.", [[kb_btn(icon('back')." بازگشت", "cust:menu")]]); return; }
    $txt = "🛍️ <b>فروشگاه ویژن مدیا</b>\nخدمات فعال:";
    $kb = [];
    foreach ($items as $it) { $kb[] = [ kb_btn("مشاهده «{$it['name']}»", "cust:store:item:".$it['id']) ]; }
    $kb[] = [ kb_btn(icon('back')." بازگشت", "cust:menu") ];
    tg_send_html($chat_id, $txt, $kb);
}
function cust_store_item(int $chat_id, int $id): void {
    $it = store_get($id); if (!$it || empty($it['active'])) { tg_send_html($chat_id, "این مورد در دسترس نیست."); return; }
    $txt = "<b>{$it['name']}</b>\nقیمت: ".number_format((int)$it['price'])." تومان\n".$it['desc'];
    $kb = [
        [ kb_btn("درخواست خرید کارت‌به‌کارت 🧾", "cust:buy:".$id) ],
        [ kb_btn("⬅️ لیست خدمات", "cust:store") ]
    ];
    tg_send_html($chat_id, $txt, $kb);
    if (!empty($it['img'])) tg_api('sendPhoto', ['chat_id'=>$chat_id,'photo'=>$it['img'],'caption'=>$it['name']]);
}
