<?php
// handlers/start_roles.php — vm2_* role onboarding & notify accounting
if (!function_exists('vm2_roles_path')) {
  function vm2_roles_path(){ return __DIR__.'/../storage/roles.json'; }
  function vm2_roles_read(){ $f=vm2_roles_path(); if(!is_file($f)) return []; $d=@json_decode(@file_get_contents($f),true); return is_array($d)?$d:[]; }
  function vm2_roles_write($d){ @mkdir(dirname(vm2_roles_path()),0777,true); @file_put_contents(vm2_roles_path(),json_encode($d,JSON_UNESCAPED_UNICODE|JSON_PRETTY_PRINT)); }
}
if (!function_exists('vm2_start_roles_menu')) {
  function vm2_start_roles_menu($chat_id){
    $kb=['inline_keyboard'=>[[['text'=>'👤 مشتری هستم','callback_data'=>'start:role:customer']],[['text'=>'🧑‍💼 پرسنل هستم','callback_data'=>'start:role:employee']]]];
    tg_send_html($chat_id,"لطفاً نقش خود را انتخاب کنید:",$kb);
  }
}
if (!function_exists('vm2_start_roles_handle')) {
  function vm2_start_roles_handle($data,$chat_id,$from){
    if ($data==='start:role:customer' || $data==='start:role:employee'){
      $roles=vm2_roles_read(); $uid=(string)($from['id']??$chat_id);
      $roles[$uid]=[ 'uid'=>$uid,'role'=>$data==='start:role:customer'?'customer':'employee','status'=>'pending','requested_at'=>time() ];
      vm2_roles_write($roles);
      // notify accounting (if acc_req_center exists they will see it there)
      tg_send_html($chat_id,"درخواست نقش ثبت شد ✅\nمنتظر بررسی حسابداری باشید.");
      // Ideally notify accountant chat(s) here if known; left as integration hook.
      return;
    }
  }
}
